/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.RecordSerializable;
import org.neo4j.kernel.impl.store.record.RecordSerializer;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.IndexTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV2;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;

public class SchemaRuleCommandTest {
    private final int labelId = 2;
    private final int propertyKey = 8;
    private final long id = 0L;
    private final long txId = 1337L;
    private final NeoStore neoStore = (NeoStore)Mockito.mock(NeoStore.class);
    private final SchemaStore store = (SchemaStore)Mockito.mock(SchemaStore.class);
    private final IndexingService indexes = (IndexingService)Mockito.mock(IndexingService.class);
    private final LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private final NeoStoreTransactionApplier storeApplier = new NeoStoreTransactionApplier(this.neoStore, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), LockService.NO_LOCK_SERVICE, new LockGroup(), 1337L);
    private final IndexTransactionApplier indexApplier = new IndexTransactionApplier(this.indexes, this.labelScanStore, (NodeStore)Mockito.mock(NodeStore.class), (PropertyStore)Mockito.mock(PropertyStore.class), (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), (PropertyLoader)Mockito.mock(PropertyLoader.class), 1337L, TransactionApplicationMode.INTERNAL);
    private final PhysicalLogNeoCommandReaderV2 reader = new PhysicalLogNeoCommandReaderV2();
    private final IndexRule rule = IndexRule.indexRule((long)0L, (int)2, (int)8, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);

    @Test
    public void shouldWriteCreatedSchemaRuleToStore() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, false, false);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)this.rule);
        this.storeApplier.visitSchemaRuleCommand(command);
        ((SchemaStore)Mockito.verify((Object)this.store)).updateRecord((DynamicRecord)IteratorUtil.first(afterRecords));
    }

    @Test
    public void shouldCreateIndexForCreatedSchemaRule() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, false, false);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)this.rule);
        this.indexApplier.visitSchemaRuleCommand(command);
        ((IndexingService)Mockito.verify((Object)this.indexes)).createIndex(this.rule);
    }

    @Test
    public void shouldSetLatestConstraintRule() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, true, false);
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)2, (int)8, (long)0L));
        this.storeApplier.visitSchemaRuleCommand(command);
        ((SchemaStore)Mockito.verify((Object)this.store)).updateRecord((DynamicRecord)IteratorUtil.first(afterRecords));
        ((NeoStore)Mockito.verify((Object)this.neoStore)).setLatestConstraintIntroducingTx(1337L);
    }

    @Test
    public void shouldDropSchemaRuleFromStore() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, false, false);
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)this.rule);
        this.storeApplier.visitSchemaRuleCommand(command);
        ((SchemaStore)Mockito.verify((Object)this.store)).updateRecord((DynamicRecord)IteratorUtil.first(afterRecords));
    }

    @Test
    public void shouldDropSchemaRuleFromIndex() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, false, false);
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)this.rule);
        this.indexApplier.visitSchemaRuleCommand(command);
        ((IndexingService)Mockito.verify((Object)this.indexes)).dropIndex(this.rule);
    }

    @Test
    public void shouldWriteSchemaRuleToLog() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, false, false);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)this.rule);
        InMemoryLogChannel buffer = new InMemoryLogChannel();
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        new CommandWriter((WritableLogChannel)buffer).visitSchemaRuleCommand(command);
        Command readCommand = this.reader.read((ReadableLogChannel)buffer);
        Assert.assertThat((Object)readCommand, (Matcher)CoreMatchers.instanceOf(Command.SchemaRuleCommand.class));
        this.assertSchemaRule((Command.SchemaRuleCommand)readCommand);
    }

    @Test
    public void shouldRecreateSchemaRuleWhenDeleteCommandReadFromDisk() throws Exception {
        Collection<DynamicRecord> beforeRecords = this.serialize((SchemaRule)this.rule, 0L, true, true);
        Collection<DynamicRecord> afterRecords = this.serialize((SchemaRule)this.rule, 0L, false, false);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, (SchemaRule)this.rule);
        InMemoryLogChannel buffer = new InMemoryLogChannel();
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.store);
        new CommandWriter((WritableLogChannel)buffer).visitSchemaRuleCommand(command);
        Command readCommand = this.reader.read((ReadableLogChannel)buffer);
        Assert.assertThat((Object)readCommand, (Matcher)CoreMatchers.instanceOf(Command.SchemaRuleCommand.class));
        this.assertSchemaRule((Command.SchemaRuleCommand)readCommand);
    }

    private Collection<DynamicRecord> serialize(SchemaRule rule, long id, boolean inUse, boolean created) {
        RecordSerializer serializer = new RecordSerializer();
        serializer = serializer.append((RecordSerializable)rule);
        DynamicRecord record = new DynamicRecord(id);
        record.setData(serializer.serialize());
        if (created) {
            record.setCreated();
        }
        if (inUse) {
            record.setInUse(true);
        }
        return Arrays.asList(record);
    }

    private void assertSchemaRule(Command.SchemaRuleCommand readSchemaCommand) {
        Assert.assertEquals((long)0L, (long)readSchemaCommand.getKey());
        Assert.assertEquals((long)2L, (long)((IndexRule)readSchemaCommand.getSchemaRule()).getLabel());
        Assert.assertEquals((long)8L, (long)((IndexRule)readSchemaCommand.getSchemaRule()).getPropertyKey());
    }
}

