/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class SpecificDepthTraversalTest
extends TraversalTestBase {
    private Transaction tx;

    @Before
    public void createTheGraph() {
        this.createGraph("0 ROOT 1", "1 KNOWS 2", "2 KNOWS 3", "2 KNOWS 4", "4 KNOWS 5", "5 KNOWS 6", "3 KNOWS 1");
        this.tx = this.beginTx();
    }

    @After
    public void tearDown() {
        this.tx.finish();
    }

    @Test
    public void shouldGetStartNodeOnDepthZero() {
        TraversalDescription description = Traversal.description().evaluator(Evaluators.atDepth((int)0));
        this.expectNodes(description.traverse(this.getNodeWithName("6")), "6");
    }

    @Test
    public void shouldGetCorrectNodesFromToDepthOne() {
        TraversalDescription description = Traversal.description().evaluator(Evaluators.fromDepth((int)1)).evaluator(Evaluators.toDepth((int)1));
        this.expectNodes(description.traverse(this.getNodeWithName("6")), "5");
    }

    @Test
    public void shouldGetCorrectNodeAtDepthOne() {
        TraversalDescription description = Traversal.description().evaluator(Evaluators.atDepth((int)1));
        this.expectNodes(description.traverse(this.getNodeWithName("6")), "5");
    }

    @Test
    public void shouldGetCorrectNodesAtDepthZero() {
        TraversalDescription description = Traversal.description().evaluator(Evaluators.fromDepth((int)0)).evaluator(Evaluators.toDepth((int)0));
        this.expectNodes(description.traverse(this.getNodeWithName("6")), "6");
    }

    @Test
    public void shouldGetStartNodeWhenFromToIsZeroBreadthFirst() {
        TraversalDescription description = Traversal.description().breadthFirst().evaluator(Evaluators.fromDepth((int)0)).evaluator(Evaluators.toDepth((int)0));
        this.expectNodes(description.traverse(this.getNodeWithName("0")), "0");
    }

    @Test
    public void shouldGetStartNodeWhenAtIsZeroBreadthFirst() {
        TraversalDescription description = Traversal.description().breadthFirst().evaluator(Evaluators.atDepth((int)0));
        this.expectNodes(description.traverse(this.getNodeWithName("2")), "2");
    }

    @Test
    public void shouldGetSecondNodeWhenFromToIsTwoBreadthFirst() {
        TraversalDescription description = Traversal.description().breadthFirst().evaluator(Evaluators.fromDepth((int)2)).evaluator(Evaluators.toDepth((int)2));
        this.expectNodes(description.traverse(this.getNodeWithName("5")), "2");
    }

    @Test
    public void shouldGetSecondNodeWhenAtIsTwoBreadthFirst() {
        TraversalDescription description = Traversal.description().breadthFirst().evaluator(Evaluators.atDepth((int)2));
        this.expectNodes(description.traverse(this.getNodeWithName("6")), "4");
    }
}

