/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestBranchState
extends TraversalTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void depthAsState() throws Exception {
        this.createGraph("a to b", "b to c", "c to d", "b to e", "e to f", "f to d", "f to g", "g to h");
        Transaction tx = this.beginTx();
        try {
            DepthStateExpander expander = new DepthStateExpander();
            IteratorUtil.count((Iterable)Traversal.traversal().expand((PathExpander)expander, Traversal.initialState((Object)0)).traverse(this.getNodeWithName("a")));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void everyOtherDepthAsState() throws Exception {
        this.createGraph("a to b", "b to c", "c to d", "d to e");
        Transaction tx = this.beginTx();
        try {
            IncrementEveryOtherDepthCountingExpander expander = new IncrementEveryOtherDepthCountingExpander();
            IteratorUtil.count((Iterable)Traversal.traversal().expand((PathExpander)expander, Traversal.initialState((Object)0)).traverse(this.getNodeWithName("a")));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void evaluateState() throws Exception {
        this.createGraph("a TO b", "b TO c", "c TO d", "a TO e", "e TO f", "f TO c");
        Transaction tx = this.beginTx();
        try {
            PathEvaluator.Adapter<Integer> evaluator = new PathEvaluator.Adapter<Integer>(){

                public Evaluation evaluate(Path path, BranchState<Integer> state) {
                    return Evaluation.ofIncludes((path.endNode().getProperty("name").equals("c") && (Integer)state.getState() == 3 ? 1 : 0) != 0);
                }
            };
            this.expectPaths(Traversal.traversal((UniquenessFactory)Uniqueness.NODE_PATH).expand((PathExpander)new RelationshipWeightExpander(), (InitialBranchState)new InitialBranchState.State((Object)1, (Object)1)).evaluator((PathEvaluator)evaluator).traverse(this.getNodeWithName("a")), "a,b,c");
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private static class RelationshipWeightExpander
    implements PathExpander<Integer> {
        private RelationshipWeightExpander() {
        }

        public Iterable<Relationship> expand(Path path, BranchState<Integer> state) {
            state.setState((Object)((Integer)state.getState() + 1));
            return path.endNode().getRelationships(Direction.OUTGOING);
        }

        public PathExpander<Integer> reverse() {
            return this;
        }
    }

    private static class IncrementEveryOtherDepthCountingExpander
    implements PathExpander<Integer> {
        private IncrementEveryOtherDepthCountingExpander() {
        }

        public Iterable<Relationship> expand(Path path, BranchState<Integer> state) {
            Assert.assertEquals((long)(path.length() / 2), (long)((Integer)state.getState()).intValue());
            if (path.length() % 2 == 1) {
                state.setState((Object)((Integer)state.getState() + 1));
            }
            return path.endNode().getRelationships(Direction.OUTGOING);
        }

        public PathExpander<Integer> reverse() {
            return this;
        }
    }

    private static class DepthStateExpander
    implements PathExpander<Integer> {
        private DepthStateExpander() {
        }

        public Iterable<Relationship> expand(Path path, BranchState<Integer> state) {
            Assert.assertEquals((long)path.length(), (long)((Integer)state.getState()).intValue());
            state.setState((Object)((Integer)state.getState() + 1));
            return path.endNode().getRelationships(Direction.OUTGOING);
        }

        public PathExpander<Integer> reverse() {
            return this;
        }
    }
}

