/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.function.Factory;

public class AutoCreatingHashMap<K, V>
extends HashMap<K, V> {
    private final Factory<V> valueCreator;

    public AutoCreatingHashMap(Factory<V> valueCreator) {
        this.valueCreator = valueCreator;
    }

    @Override
    public V get(Object key) {
        if (!super.containsKey(key)) {
            this.put(key, this.valueCreator.newInstance());
        }
        return super.get(key);
    }

    public static <V> Factory<V> values(final Class<V> valueType) {
        return new Factory<V>(){

            public V newInstance() {
                try {
                    return valueType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static <K, V> Factory<Map<K, V>> nested(Class<K> keyClass, final Factory<V> nested) {
        return new Factory<Map<K, V>>(){

            public Map<K, V> newInstance() {
                return new AutoCreatingHashMap(nested);
            }
        };
    }
}

