/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.util.CopyOnWriteAfterIteratorHashSet;

public class CopyOnWriteAfterIteratorHashSetTest {
    @Test
    public void should_not_change_iterated_snapshot_by_adding() {
        CopyOnWriteAfterIteratorHashSet<String> set = this.newCOWSet("hullo");
        Snapshot<String> initialSnapshot = this.snapshot(set);
        set.add((Object)"wurld");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo"}), initialSnapshot.toSet());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo", "wurld"}), this.snapshot(set).toSet());
    }

    @Test
    public void should_not_change_iterated_snapshot_by_removing() {
        CopyOnWriteAfterIteratorHashSet<String> set = this.newCOWSet("hullo", "wurld");
        Snapshot<String> initialSnapshot = this.snapshot(set);
        set.remove((Object)"wurld");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo", "wurld"}), initialSnapshot.toSet());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo"}), this.snapshot(set).toSet());
    }

    @Test
    public void should_not_change_iterated_snapshot_by_clearing() {
        CopyOnWriteAfterIteratorHashSet<String> set = this.newCOWSet("hullo", "wurld");
        Snapshot<String> initialSnapshot = this.snapshot(set);
        set.clear();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo", "wurld"}), initialSnapshot.toSet());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[0]), this.snapshot(set).toSet());
    }

    @Test
    public void should_support_multiple_stable_snapshots() {
        CopyOnWriteAfterIteratorHashSet<String> set = this.newCOWSet(new String[0]);
        set.add((Object)"hullo");
        Snapshot<String> snapshot1 = this.snapshot(set);
        set.add((Object)"wurld");
        Snapshot<String> snapshot2 = this.snapshot(set);
        set.add((Object)"!");
        set.remove((Object)"wurld");
        Snapshot<String> snapshot3 = this.snapshot(set);
        set.clear();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo"}), snapshot1.toSet());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo", "wurld"}), snapshot2.toSet());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo", "!"}), snapshot3.toSet());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[0]), this.snapshot(set).toSet());
    }

    @Test
    public void should_not_change_iterated_snapshot_by_retaining_all() {
        CopyOnWriteAfterIteratorHashSet<String> set = this.newCOWSet("hullo", "wurld", "!");
        Snapshot<String> initialSnapshot = this.snapshot(set);
        set.retainAll(Arrays.asList("!", "!"));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo", "wurld", "!"}), initialSnapshot.toSet());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"!"}), this.snapshot(set).toSet());
    }

    @Test
    public void should_not_change_iterated_snapshot_by_removing_all() {
        CopyOnWriteAfterIteratorHashSet<String> set = this.newCOWSet("hullo", "wurld", "!");
        Snapshot<String> initialSnapshot = this.snapshot(set);
        set.removeAll(Arrays.asList("!", "!"));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo", "wurld", "!"}), initialSnapshot.toSet());
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"hullo", "wurld"}), this.snapshot(set).toSet());
    }

    private CopyOnWriteAfterIteratorHashSet<String> newCOWSet(String ... elements) {
        CopyOnWriteAfterIteratorHashSet result = new CopyOnWriteAfterIteratorHashSet();
        Collections.addAll(result, elements);
        return result;
    }

    private Snapshot<String> snapshot(CopyOnWriteAfterIteratorHashSet<String> set) {
        return new Snapshot<String>(set.iterator());
    }

    private class Snapshot<E> {
        private final Iterator<E> input;

        private Snapshot(Iterator<E> input) {
            this.input = input;
        }

        public Set<E> toSet() {
            return IteratorUtil.asSet(this.input);
        }
    }
}

