/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.impl.util.LazySingleReference;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OtherThreadExecutor;

public class LazySingleReferenceTest {
    private OtherThreadExecutor<Void> t1;
    private OtherThreadExecutor<Void> t2;

    @Test
    public void shouldOnlyAllowSingleThreadToInitialize() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger initCalls = new AtomicInteger();
        LazySingleReference<Integer> ref = new LazySingleReference<Integer>(){

            protected Integer create() {
                DoubleLatch.awaitLatch(latch);
                return initCalls.incrementAndGet();
            }
        };
        Future<Integer> t1Evaluate = this.t1.executeDontWait(this.evaluate(ref));
        this.t1.waitUntilWaiting();
        Future<Integer> t2Evaluate = this.t2.executeDontWait(this.evaluate(ref));
        this.t2.waitUntilBlocked();
        latch.countDown();
        int e1 = t1Evaluate.get();
        int e2 = t2Evaluate.get();
        Assert.assertEquals((String)"T1 evaluation", (long)1L, (long)e1);
        Assert.assertEquals((String)"T2 evaluation", (long)1L, (long)e2);
    }

    @Test
    public void shouldMutexAccessBetweenInvalidateAndinstance() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger initCalls = new AtomicInteger();
        LazySingleReference<Integer> ref = new LazySingleReference<Integer>(){

            protected Integer create() {
                DoubleLatch.awaitLatch(latch);
                return initCalls.incrementAndGet();
            }
        };
        Future<Integer> t1Evaluate = this.t1.executeDontWait(this.evaluate(ref));
        this.t1.waitUntilWaiting();
        Future<Void> t2Invalidate = this.t2.executeDontWait(this.invalidate(ref));
        this.t2.waitUntilBlocked();
        latch.countDown();
        int e = t1Evaluate.get();
        t2Invalidate.get();
        Assert.assertEquals((String)"Evaluation", (long)1L, (long)e);
    }

    @Test
    public void shouldInitializeAgainAfterInvalidated() throws Exception {
        final AtomicInteger initCalls = new AtomicInteger();
        LazySingleReference<Integer> ref = new LazySingleReference<Integer>(){

            protected Integer create() {
                return initCalls.incrementAndGet();
            }
        };
        Assert.assertEquals((String)"First evaluation", (long)1L, (long)((Integer)ref.instance()).intValue());
        ref.invalidate();
        int e2 = (Integer)ref.instance();
        Assert.assertEquals((String)"Second evaluation", (long)2L, (long)e2);
    }

    @Test
    public void shouldRespondToIsInitialized() throws Exception {
        LazySingleReference<Integer> ref = new LazySingleReference<Integer>(){

            protected Integer create() {
                return 1;
            }
        };
        boolean firstResult = ref.isCreated();
        ref.instance();
        boolean secondResult = ref.isCreated();
        ref.invalidate();
        boolean thirdResult = ref.isCreated();
        ref.instance();
        boolean fourthResult = ref.isCreated();
        Assert.assertFalse((String)"Should not start off as initialized", (boolean)firstResult);
        Assert.assertTrue((String)"Should be initialized after an evaluation", (boolean)secondResult);
        Assert.assertFalse((String)"Should not be initialized after invalidated", (boolean)thirdResult);
        Assert.assertTrue((String)"Should be initialized after a re-evaluation", (boolean)fourthResult);
    }

    @Before
    public void before() {
        this.t1 = new OtherThreadExecutor<Object>("T1", null);
        this.t2 = new OtherThreadExecutor<Object>("T2", null);
    }

    @After
    public void after() {
        this.t2.close();
        this.t1.close();
    }

    private OtherThreadExecutor.WorkerCommand<Void, Integer> evaluate(final LazySingleReference<Integer> ref) {
        return new OtherThreadExecutor.WorkerCommand<Void, Integer>(){

            @Override
            public Integer doWork(Void state) throws Exception {
                return (Integer)ref.instance();
            }
        };
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> invalidate(final LazySingleReference<Integer> ref) {
        return new OtherThreadExecutor.WorkerCommand<Void, Void>(){

            @Override
            public Void doWork(Void state) throws Exception {
                ref.invalidate();
                return null;
            }
        };
    }
}

