/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;

public class Neo4jJobSchedulerTest {
    private Neo4jJobScheduler scheduler;
    private AtomicInteger invocations;
    private Runnable countInvocationsJob = new Runnable(){

        @Override
        public void run() {
            try {
                Neo4jJobSchedulerTest.this.invocations.incrementAndGet();
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw Exceptions.launderedException((Throwable)e);
            }
        }
    };

    @Before
    public void initInvocation() {
        this.invocations = new AtomicInteger(0);
    }

    @After
    public void stopScheduler() throws Throwable {
        this.scheduler.shutdown();
    }

    @Test
    public void shouldRunRecurringJob() throws Throwable {
        long period = 1000L;
        int count = 2;
        this.scheduler = new Neo4jJobScheduler();
        this.scheduler.init();
        this.scheduler.scheduleRecurring(JobScheduler.Group.indexPopulation, this.countInvocationsJob, period, TimeUnit.MILLISECONDS);
        this.awaitFirstInvocation();
        Thread.sleep(period * (long)count - period / 2L);
        this.scheduler.shutdown();
        int actualInvocations = this.invocations.get();
        Assert.assertEquals((long)count, (long)actualInvocations);
        Thread.sleep(period);
        MatcherAssert.assertThat((Object)this.invocations.get(), (Matcher)Matchers.equalTo((Object)actualInvocations));
    }

    @Test
    public void shouldCancelRecurringJob() throws Exception {
        long period = 2L;
        this.scheduler = new Neo4jJobScheduler();
        this.scheduler.init();
        JobScheduler.JobHandle jobHandle = this.scheduler.scheduleRecurring(JobScheduler.Group.indexPopulation, this.countInvocationsJob, period, TimeUnit.MILLISECONDS);
        this.awaitFirstInvocation();
        jobHandle.cancel(false);
        int recorded = this.invocations.get();
        Thread.sleep(period * 100L);
        MatcherAssert.assertThat((Object)this.invocations.get(), (Matcher)Matchers.equalTo((Object)recorded));
    }

    private void awaitFirstInvocation() {
        while (this.invocations.get() == 0) {
            Thread.yield();
        }
    }
}

