/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.NumberUtil;

public class NumberUtilTest {
    @Test
    public void shouldSeeZeroAsPositive() throws Exception {
        Assert.assertTrue((boolean)NumberUtil.signOf((long)0L));
    }

    @Test
    public void shouldSeeArbitraryPositiveValuesAsPositive() throws Exception {
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)NumberUtil.signOf((long)Math.abs(random.nextLong())));
        }
        Assert.assertTrue((boolean)NumberUtil.signOf((long)Long.MAX_VALUE));
    }

    @Test
    public void shouldSeeArbitraryNegativeValuesAsNegative() throws Exception {
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)NumberUtil.signOf((long)(-Math.abs(random.nextLong()))));
        }
        Assert.assertFalse((boolean)NumberUtil.signOf((long)Long.MIN_VALUE));
    }

    @Test
    public void shouldSeeNumbersOfSameSignAsSameSign() throws Exception {
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)NumberUtil.haveSameSign((long)Math.abs(random.nextLong()), (long)Math.abs(random.nextLong())));
        }
    }

    @Test
    public void shouldSeeNumbersOfDifferentSignAsDifferentSign() throws Exception {
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)NumberUtil.haveSameSign((long)Math.abs(random.nextLong()), (long)(-Math.abs(random.nextLong()))));
            Assert.assertFalse((boolean)NumberUtil.haveSameSign((long)(-Math.abs(random.nextLong())), (long)Math.abs(random.nextLong())));
        }
    }
}

