/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitable;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.LogMarker;

public class TestLogger
extends StringLogger {
    private final List<LogCall> logCalls = new ArrayList<LogCall>();

    public void assertExactly(LogCall ... expectedLogCalls) {
        Iterator<LogCall> expected = Arrays.asList(expectedLogCalls).iterator();
        Iterator<LogCall> actual = this.logCalls.iterator();
        while (expected.hasNext()) {
            if (actual.hasNext()) {
                Assert.assertEquals((Object)expected.next(), (Object)actual.next());
                continue;
            }
            Assert.fail((String)String.format("Got fewer log calls than expected. The missing log calls were: \n%s", this.serialize(expected)));
        }
        if (actual.hasNext()) {
            Assert.fail((String)String.format("Got more log calls than expected. The remaining log calls were: \n%s", this.serialize(actual)));
        }
    }

    public void assertAtLeastOnce(LogCall ... expectedCalls) {
        Set expected = IteratorUtil.asSet((Object[])expectedCalls);
        for (LogCall logCall : this.logCalls) {
            expected.remove(logCall);
        }
        if (expected.size() > 0) {
            Assert.fail((String)("These log calls were expected, but never occurred: \n" + this.serialize(expected.iterator()) + "\nActual log calls were:\n" + this.serialize(this.logCalls.iterator())));
        }
    }

    public void assertContainsMessageContaining(String partOfMessage) {
        for (LogCall logCall : this.logCalls) {
            if (!logCall.message.contains(partOfMessage)) continue;
            return;
        }
        Assert.fail((String)("Expected at least one log statement containing '" + partOfMessage + "', but none found. ctual log calls were:\n" + this.serialize(this.logCalls.iterator())));
    }

    public void assertNoDebugs() {
        this.assertNo(this.hasLevel(Level.DEBUG), "Expected no messages with level DEBUG.");
    }

    public void assertNoInfos() {
        this.assertNo(this.hasLevel(Level.INFO), "Expected no messages with level INFO.");
    }

    public void assertNoWarnings() {
        this.assertNo(this.hasLevel(Level.WARN), "Expected no messages with level WARN.");
    }

    public void assertNoErrors() {
        this.assertNo(this.hasLevel(Level.ERROR), "Expected no messages with level ERROR.");
    }

    public void assertNoLoggingOccurred() {
        if (this.logCalls.size() != 0) {
            Assert.fail((String)("Expected no log messages at all, but got:\n" + this.serialize(this.logCalls.iterator())));
        }
    }

    public void assertNo(LogCall call) {
        long found = Iterables.count((Iterable)Iterables.filter((Predicate)Predicates.equalTo((Object)call), this.logCalls));
        if (found != 0L) {
            Assert.fail((String)("Expected no occurrence of " + call + ", but it was in fact logged " + found + " times."));
        }
    }

    public void assertNo(Predicate<LogCall> predicate, String failMessage) {
        Iterable found = Iterables.filter(predicate, this.logCalls);
        if (Iterables.count((Iterable)found) != 0L) {
            Assert.fail((String)(failMessage + " But found: \n" + this.serialize(found.iterator())));
        }
    }

    public void clear() {
        this.logCalls.clear();
    }

    private void log(Level level, String message, Throwable cause) {
        this.logCalls.add(new LogCall(level, message, cause, false));
    }

    public void debug(String msg) {
        this.debug(msg, null);
    }

    public void debug(String msg, Throwable cause) {
        this.log(Level.DEBUG, msg, cause);
    }

    public void info(String msg) {
        this.info(msg, null);
    }

    public void info(String msg, Throwable cause) {
        this.log(Level.INFO, msg, cause);
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String msg, Throwable cause) {
        this.log(Level.WARN, msg, cause);
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Throwable cause) {
        this.log(Level.ERROR, msg, cause);
    }

    public void logMessage(String msg, Throwable cause, boolean flush) {
        this.log(Level.UNKNOWN, msg, cause);
    }

    public void logMessage(String msg, boolean flush) {
        this.logMessage(msg, null, flush);
    }

    public void logMessage(String msg, LogMarker marker) {
        this.logMessage(msg, null, false);
    }

    protected void logLine(String line) {
        this.logMessage(line);
    }

    public void logLongMessage(String msg, Visitor<StringLogger.LineLogger, RuntimeException> source, boolean flush) {
        source.visit((Object)new StringLogger.LineLoggerImpl((StringLogger)this));
    }

    public void addRotationListener(Runnable listener) {
    }

    public void flush() {
    }

    public void close() {
    }

    private String serialize(Iterator<LogCall> events) {
        StringBuilder sb = new StringBuilder();
        while (events.hasNext()) {
            sb.append(events.next().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void visitLogCalls(Visitor<LogCall, RuntimeException> visitor) {
        for (LogCall logCall : this.logCalls) {
            logCall.accept(visitor);
        }
    }

    private Predicate<LogCall> hasLevel(final Level level) {
        return new Predicate<LogCall>(){

            public boolean accept(LogCall item) {
                return item.level == level;
            }
        };
    }

    public static final class LogCall
    implements Visitable<LogCall> {
        protected final Level level;
        protected final String message;
        protected final Throwable cause;
        protected final boolean flush;

        private LogCall(Level level, String message, Throwable cause, boolean flush) {
            this.level = level;
            this.message = message;
            this.cause = cause;
            this.flush = flush;
        }

        public static LogCall debug(String msg) {
            return new LogCall(Level.DEBUG, msg, null, false);
        }

        public static LogCall info(String msg) {
            return new LogCall(Level.INFO, msg, null, false);
        }

        public static LogCall warn(String msg) {
            return new LogCall(Level.WARN, msg, null, false);
        }

        public static LogCall error(String msg) {
            return new LogCall(Level.ERROR, msg, null, false);
        }

        public static LogCall debug(String msg, Throwable c) {
            return new LogCall(Level.DEBUG, msg, c, false);
        }

        public static LogCall info(String msg, Throwable c) {
            return new LogCall(Level.INFO, msg, c, false);
        }

        public static LogCall warn(String msg, Throwable c) {
            return new LogCall(Level.WARN, msg, c, false);
        }

        public static LogCall error(String msg, Throwable c) {
            return new LogCall(Level.ERROR, msg, c, false);
        }

        public void accept(Visitor<LogCall, RuntimeException> visitor) {
            visitor.visit((Object)this);
        }

        public String toString() {
            return "LogCall{ " + (Object)((Object)this.level) + ", message='" + this.message + '\'' + ", cause=" + this.cause + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogCall logCall = (LogCall)o;
            return this.flush == logCall.flush && this.level == logCall.level && this.message.equals(logCall.message) && !(this.cause == null ? logCall.cause != null : !this.cause.equals(logCall.cause));
        }

        public int hashCode() {
            int result = this.level.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + (this.cause != null ? this.cause.hashCode() : 0);
            result = 31 * result + (this.flush ? 1 : 0);
            return result;
        }
    }

    private static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        UNKNOWN;

    }
}

