/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.TestLogger;

public class TestTestLogger {
    @Test
    public void shouldPassExactAssertions() throws Exception {
        TestLogger logger = new TestLogger();
        Throwable cause = new Throwable("This is a throwable!");
        logger.debug("Debug");
        logger.debug("Debug", cause);
        logger.info("Info");
        logger.info("Info", cause);
        logger.warn("Warn");
        logger.warn("Warn", cause);
        logger.error("Error");
        logger.error("Error", cause);
        logger.assertExactly(TestLogger.LogCall.debug("Debug"), TestLogger.LogCall.debug("Debug", cause), TestLogger.LogCall.info("Info"), TestLogger.LogCall.info("Info", cause), TestLogger.LogCall.warn("Warn"), TestLogger.LogCall.warn("Warn", cause), TestLogger.LogCall.error("Error"), TestLogger.LogCall.error("Error", cause));
    }

    @Test
    public void shouldFailNicelyIfTooManyLogCalls() throws Exception {
        TestLogger logger = new TestLogger();
        logger.debug("Debug");
        logger.debug("Debug 2");
        try {
            logger.assertExactly(TestLogger.LogCall.debug("Debug"));
            Assert.fail((String)"Should have failed.");
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)IsEqual.equalTo((Object)"Got more log calls than expected. The remaining log calls were: \nLogCall{ DEBUG, message='Debug 2', cause=null}\n"));
        }
    }

    @Test
    public void shouldFailIfTooFewLogCalls() throws Exception {
        TestLogger logger = new TestLogger();
        try {
            logger.assertExactly(TestLogger.LogCall.debug("Debug"));
            Assert.fail((String)"Should have failed.");
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)IsEqual.equalTo((Object)"Got fewer log calls than expected. The missing log calls were: \nLogCall{ DEBUG, message='Debug', cause=null}\n"));
        }
    }

    @Test
    public void shouldPassIfContains() throws Exception {
        TestLogger logger = new TestLogger();
        logger.debug("Debug 1");
        logger.debug("Debug 2");
        logger.debug("Debug 3");
        logger.assertAtLeastOnce(TestLogger.LogCall.debug("Debug 2"), TestLogger.LogCall.debug("Debug 1"));
    }

    @Test
    public void shouldFailIfDoesntContain() throws Exception {
        TestLogger logger = new TestLogger();
        logger.debug("Debug 1");
        logger.debug("Debug 3");
        try {
            logger.assertAtLeastOnce(TestLogger.LogCall.debug("Debug 2"), TestLogger.LogCall.debug("Debug 1"));
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)IsEqual.equalTo((Object)"These log calls were expected, but never occurred: \nLogCall{ DEBUG, message='Debug 2', cause=null}\n\nActual log calls were:\nLogCall{ DEBUG, message='Debug 1', cause=null}\nLogCall{ DEBUG, message='Debug 3', cause=null}\n"));
        }
    }

    @Test
    public void shouldPassOnEmptyAsserters() throws Exception {
        TestLogger logger = new TestLogger();
        logger.assertNoDebugs();
        logger.assertNoInfos();
        logger.assertNoWarnings();
        logger.assertNoErrors();
        logger.assertNoLoggingOccurred();
    }

    @Test
    public void shouldFailOnNonEmptyAsserters() throws Exception {
        TestLogger logger = new TestLogger();
        try {
            logger.debug("Debug");
            logger.assertNoErrors();
            logger.assertNoWarnings();
            logger.assertNoInfos();
            logger.assertNoDebugs();
            Assert.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)IsEqual.equalTo((Object)"Expected no messages with level DEBUG. But found: \nLogCall{ DEBUG, message='Debug', cause=null}\n"));
        }
        try {
            logger.info("Info");
            logger.assertNoErrors();
            logger.assertNoWarnings();
            logger.assertNoInfos();
            Assert.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)IsEqual.equalTo((Object)"Expected no messages with level INFO. But found: \nLogCall{ INFO, message='Info', cause=null}\n"));
        }
        try {
            logger.warn("Warn");
            logger.assertNoErrors();
            logger.assertNoWarnings();
            Assert.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)IsEqual.equalTo((Object)"Expected no messages with level WARN. But found: \nLogCall{ WARN, message='Warn', cause=null}\n"));
        }
        try {
            logger.error("Error");
            logger.assertNoErrors();
            Assert.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)IsEqual.equalTo((Object)"Expected no messages with level ERROR. But found: \nLogCall{ ERROR, message='Error', cause=null}\n"));
        }
        try {
            logger.assertNoLoggingOccurred();
            Assert.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)IsEqual.equalTo((Object)"Expected no log messages at all, but got:\nLogCall{ DEBUG, message='Debug', cause=null}\nLogCall{ INFO, message='Info', cause=null}\nLogCall{ WARN, message='Warn', cause=null}\nLogCall{ ERROR, message='Error', cause=null}\n"));
        }
        try {
            logger.debug("This is a message.");
            logger.debug("This is a message.");
            logger.assertNo(TestLogger.LogCall.debug("This is a message."));
            Assert.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            Assert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)IsEqual.equalTo((Object)"Expected no occurrence of LogCall{ DEBUG, message='This is a message.', cause=null}, but it was in fact logged 2 times."));
        }
    }
}

