/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.statistics;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.kernel.impl.util.statistics.RollingAverage;

public class RollingAverageTest {
    @Test
    public void shouldCalcAverage() throws Exception {
        RollingAverage avg = new RollingAverage(new RollingAverage.Parameters(100L, 1.0E-4));
        avg.record(1L);
        avg.record(2L);
        avg.record(2L);
        avg.record(3L);
        double result = avg.average();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.closeTo((double)2.0, (double)0.01));
    }

    @Test
    public void shouldCalcAverageWhenWindowsShift() throws Exception {
        RollingAverage avg = new RollingAverage(new RollingAverage.Parameters(2L, 1.0E-4));
        avg.record(10L);
        avg.record(2L);
        avg.record(2L);
        avg.record(3L);
        avg.record(2L);
        avg.record(2L);
        double result = avg.average();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.closeTo((double)2.5, (double)0.1));
    }
}

