/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.qa.tooling;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.qa.tooling.DumpProcessInformation;
import org.neo4j.qa.tooling.DumpableProcess;
import org.neo4j.test.TargetDirectory;

public class DumpProcessInformationTest {
    private static final String SIGNAL = "here";
    private final File directory = TargetDirectory.forTest(this.getClass()).cleanDirectory("dump");

    @Test
    public void shouldDumpProcessInformation() throws Exception {
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), DumpableProcess.class.getName(), SIGNAL});
        this.awaitSignal(process);
        DumpProcessInformation dumper = new DumpProcessInformation((Logging)new DevNullLoggingService(), this.directory);
        Pair pid = (Pair)IteratorUtil.single(dumper.getJPids((Predicate<String>)Predicates.stringContains((String)DumpableProcess.class.getSimpleName())));
        File threaddumpFile = dumper.doThreadDump((Pair<Long, String>)pid);
        process.destroy();
        Assert.assertTrue((boolean)this.fileContains(threaddumpFile, "traceableMethod", DumpableProcess.class.getName()));
    }

    private boolean fileContains(File file, String ... expectedStrings) {
        Set expectedStringSet = IteratorUtil.asSet((Object[])expectedStrings);
        for (String line : IteratorUtil.asIterable((File)file, (String)"UTF-8")) {
            Iterator expectedStringIterator = expectedStringSet.iterator();
            while (expectedStringIterator.hasNext()) {
                if (!line.contains((CharSequence)expectedStringIterator.next())) continue;
                expectedStringIterator.remove();
            }
        }
        return expectedStringSet.isEmpty();
    }

    private void awaitSignal(Process process) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = reader.readLine();
            if (!SIGNAL.equals(line)) {
                Assert.fail((String)("Got weird signal " + line));
            }
        }
    }
}

