/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.CountDownLatch;

public interface Barrier {
    public static final Barrier NONE = new Barrier(){

        @Override
        public void reached() {
        }
    };

    public void reached();

    public static class Control
    implements Barrier {
        private final CountDownLatch reached = new CountDownLatch(1);
        private final CountDownLatch released = new CountDownLatch(1);

        @Override
        public void reached() {
            try {
                this.reached.countDown();
                this.released.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void await() throws InterruptedException {
            this.reached.await();
        }

        public void release() {
            this.released.countDown();
        }
    }
}

