/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Provider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.test.AlgebraicFunction;

public abstract class DatabaseRule
extends ExternalResource {
    GraphDatabaseBuilder databaseBuilder;
    GraphDatabaseAPI database;
    private String storeDir;
    private Provider<Statement> statementProvider;

    public <T> T when(Function<GraphDatabaseService, T> function) {
        return (T)function.apply((Object)this.getGraphDatabaseService());
    }

    public <T> T executeAndCommit(Function<? super GraphDatabaseService, T> function) {
        return this.transaction(function, true);
    }

    public <T> T executeAndRollback(Function<? super GraphDatabaseService, T> function) {
        return this.transaction(function, false);
    }

    public <FROM, TO> AlgebraicFunction<FROM, TO> tx(final Function<FROM, TO> function) {
        return new AlgebraicFunction<FROM, TO>(){

            public TO apply(final FROM from) {
                return DatabaseRule.this.executeAndCommit(new Function<GraphDatabaseService, TO>(){

                    public TO apply(GraphDatabaseService graphDb) {
                        return function.apply(from);
                    }
                });
            }
        };
    }

    private <T> T transaction(Function<? super GraphDatabaseService, T> function, boolean commit) {
        try (Transaction tx = this.database.beginTx();){
            Object result = function.apply((Object)this.database);
            if (commit) {
                tx.success();
            }
            Object object = result;
            return (T)object;
        }
    }

    public Result execute(String query) throws QueryExecutionException {
        return this.database.execute(query);
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        return this.database.execute(query, parameters);
    }

    public Transaction beginTx() {
        return this.database.beginTx();
    }

    public Node createNode(Label ... labels) {
        return this.database.createNode(labels);
    }

    public Schema schema() {
        return this.database.schema();
    }

    protected void before() throws Throwable {
        this.create();
    }

    protected void after() {
        this.shutdown();
    }

    public void create() throws IOException {
        this.createResources();
        try {
            GraphDatabaseFactory factory = this.newFactory();
            this.configure(factory);
            this.databaseBuilder = this.newBuilder(factory);
            this.configure(this.databaseBuilder);
            this.database = (GraphDatabaseAPI)this.databaseBuilder.newGraphDatabase();
            this.storeDir = this.database.getStoreDir();
            this.statementProvider = (Provider)this.resolveDependency(ThreadToStatementContextBridge.class);
        }
        catch (RuntimeException e) {
            this.deleteResources();
            throw e;
        }
    }

    protected void deleteResources() {
    }

    protected void createResources() throws IOException {
    }

    protected abstract GraphDatabaseFactory newFactory();

    protected abstract GraphDatabaseBuilder newBuilder(GraphDatabaseFactory var1);

    protected void configure(GraphDatabaseFactory databaseFactory) {
    }

    protected void configure(GraphDatabaseBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.mapped_memory_total_size, "20M");
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.database;
    }

    public GraphDatabaseAPI getGraphDatabaseAPI() {
        return this.database;
    }

    public void restartDatabase(RestartAction action) {
        FileSystemAbstraction fs = this.resolveDependency(FileSystemAbstraction.class);
        this.database.shutdown();
        action.run(fs, new File(this.storeDir));
        this.database = (GraphDatabaseAPI)this.databaseBuilder.newGraphDatabase();
        this.statementProvider = (Provider)this.resolveDependency(ThreadToStatementContextBridge.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.statementProvider = null;
        try {
            if (this.database != null) {
                this.database.shutdown();
            }
        }
        finally {
            this.deleteResources();
            this.database = null;
        }
    }

    public void clearCache() {
        NeoStoreDataSource dataSource = (NeoStoreDataSource)this.database.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
        dataSource.getNodeCache().clear();
        dataSource.getRelationshipCache().clear();
    }

    public <T> T resolveDependency(Class<T> type) {
        return (T)this.database.getDependencyResolver().resolveDependency(type);
    }

    public Statement statement() {
        return (Statement)this.statementProvider.instance();
    }

    public static interface RestartAction {
        public static final RestartAction EMPTY = new RestartAction(){

            @Override
            public void run(FileSystemAbstraction fs, File storeDirectory) {
            }
        };

        public void run(FileSystemAbstraction var1, File var2);
    }
}

