/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.junit.rules.ExternalResource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;

public class EphemeralFileSystemRule
extends ExternalResource {
    private EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();

    protected void after() {
        this.fs.shutdown();
    }

    public EphemeralFileSystemAbstraction get() {
        return this.fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EphemeralFileSystemAbstraction snapshot(Runnable action) {
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot();
        try {
            action.run();
        }
        finally {
            this.fs.shutdown();
            this.fs = snapshot;
        }
        return this.fs;
    }

    public void clear() {
        this.fs.shutdown();
        this.fs = new EphemeralFileSystemAbstraction();
    }

    public static Runnable shutdownDb(final GraphDatabaseService db) {
        return new Runnable(){

            @Override
            public void run() {
                db.shutdown();
            }
        };
    }
}

