/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogDeserializer;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalWritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReaderFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;

public class LogTestUtils {
    public static final LogHook<Pair<Byte, List<byte[]>>> NO_FILTER = new LogHookAdapter<Pair<Byte, List<byte[]>>>(){

        public boolean accept(Pair<Byte, List<byte[]>> item) {
            return true;
        }
    };

    public static void assertLogContains(FileSystemAbstraction fileSystem, String logPath, LogEntry ... expectedEntries) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(713);
        try (StoreChannel file = fileSystem.open(new File(logPath), "r");){
            LogHeader logHeader = LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)file, (boolean)true);
            LogDeserializer deserializer = new LogDeserializer();
            PhysicalLogVersionedStoreChannel channel = new PhysicalLogVersionedStoreChannel(file, logHeader.logVersion, logHeader.logFormatVersion);
            ReadAheadLogChannel logChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)channel, LogVersionBridge.NO_MORE_CHANNELS, 4096);
            try (IOCursor cursor = deserializer.logEntries((ReadableVersionableLogChannel)logChannel);){
                int entryNo = 0;
                while (cursor.next()) {
                    Assert.assertThat((String)"The log contained more entries than we expected!", (Object)(entryNo < expectedEntries.length ? 1 : 0), (Matcher)Is.is((Object)true));
                    LogEntry expectedEntry = expectedEntries[entryNo];
                    Assert.assertThat((String)("Unexpected entry at entry number " + entryNo), (Object)cursor.get(), (Matcher)Is.is((Object)expectedEntry));
                    ++entryNo;
                }
                if (entryNo < expectedEntries.length) {
                    Assert.fail((String)("Log ended prematurely. Expected to find '" + expectedEntries[entryNo].toString() + "' as log entry number " + entryNo + ", instead there were no more log entries."));
                }
            }
        }
    }

    private static void replace(File tempFile, File file) {
        file.renameTo(new File(file.getAbsolutePath() + "." + System.currentTimeMillis()));
        tempFile.renameTo(file);
    }

    public static File[] filterNeostoreLogicalLog(FileSystemAbstraction fileSystem, String storeDir, LogHook<LogEntry> filter) throws IOException {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(new File(storeDir), fileSystem);
        final ArrayList files = new ArrayList();
        logFiles.accept(new PhysicalLogFiles.LogVersionVisitor(){

            public void visit(File file, long logVersion) {
                files.add(file);
            }
        });
        for (File file : files) {
            File filteredLog = LogTestUtils.filterNeostoreLogicalLog(fileSystem, file, filter);
            LogTestUtils.replace(filteredLog, file);
        }
        return files.toArray(new File[files.size()]);
    }

    public static File filterNeostoreLogicalLog(FileSystemAbstraction fileSystem, File file, LogHook<LogEntry> filter) throws IOException {
        filter.file(file);
        File tempFile = new File(file.getAbsolutePath() + ".tmp");
        fileSystem.deleteFile(tempFile);
        try (StoreChannel in = fileSystem.open(file, "r");
             StoreChannel out = fileSystem.open(tempFile, "rw");){
            LogEntry entry;
            ByteBuffer buffer = ByteBuffer.allocate(0x100000);
            LogHeader logHeader = LogTestUtils.transferLogicalLogHeader(in, out, buffer);
            PhysicalLogVersionedStoreChannel outChannel = new PhysicalLogVersionedStoreChannel(out, logHeader.logVersion, logHeader.logFormatVersion);
            PhysicalWritableLogChannel outBuffer = new PhysicalWritableLogChannel((LogVersionedStoreChannel)outChannel);
            PhysicalLogVersionedStoreChannel inChannel = new PhysicalLogVersionedStoreChannel(in, logHeader.logVersion, logHeader.logFormatVersion);
            ReadAheadLogChannel inBuffer = new ReadAheadLogChannel((LogVersionedStoreChannel)inChannel, LogVersionBridge.NO_MORE_CHANNELS, 4096);
            LogEntryReader entryReader = new LogEntryReaderFactory().create();
            while ((entry = entryReader.readLogEntry((ReadableLogChannel)inBuffer)) != null) {
                if (!filter.accept(entry)) continue;
            }
        }
        return tempFile;
    }

    private static LogHeader transferLogicalLogHeader(StoreChannel in, StoreChannel out, ByteBuffer buffer) throws IOException {
        LogHeader header = LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)in, (boolean)true);
        LogHeaderWriter.writeLogHeader((ByteBuffer)buffer, (long)header.logVersion, (long)header.lastCommittedTxId);
        buffer.flip();
        out.write(buffer);
        return header;
    }

    public static NonCleanLogCopy copyLogicalLog(FileSystemAbstraction fileSystem, File logBaseFileName) throws IOException {
        Throwable throwable;
        File activeLogBackup;
        char active = '1';
        File activeLog = new File(logBaseFileName.getPath() + ".active");
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        try (StoreChannel af = fileSystem.open(activeLog, "r");){
            af.read(buffer);
            buffer.flip();
            activeLogBackup = new File(logBaseFileName.getPath() + ".bak.active");
            throwable = null;
            try (StoreChannel activeCopy = fileSystem.open(activeLogBackup, "rw");){
                activeCopy.write(buffer);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        buffer.flip();
        active = buffer.asCharBuffer().get();
        buffer.clear();
        File currentLog = new File(logBaseFileName.getPath() + "." + active);
        File currentLogBackup = new File(logBaseFileName.getPath() + ".bak." + active);
        throwable = null;
        try (StoreChannel source = fileSystem.open(currentLog, "r");
             StoreChannel dest = fileSystem.open(currentLogBackup, "rw");){
            int read = -1;
            do {
                read = source.read(buffer);
                buffer.flip();
                dest.write(buffer);
                buffer.clear();
            } while (read == 1024);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return new NonCleanLogCopy(new FileBackup(activeLog, activeLogBackup, fileSystem), new FileBackup(currentLog, currentLogBackup, fileSystem));
    }

    public static class NonCleanLogCopy {
        private final FileBackup[] backups;

        NonCleanLogCopy(FileBackup ... backups) {
            this.backups = backups;
        }

        public void reinstate() throws IOException {
            for (FileBackup backup : this.backups) {
                backup.restore();
            }
        }
    }

    private static class FileBackup {
        private final File file;
        private final File backup;
        private final FileSystemAbstraction fileSystem;

        FileBackup(File file, File backup, FileSystemAbstraction fileSystem) {
            this.file = file;
            this.backup = backup;
            this.fileSystem = fileSystem;
        }

        public void restore() throws IOException {
            this.fileSystem.deleteFile(this.file);
            this.fileSystem.renameFile(this.backup, this.file);
        }
    }

    public static class CountingLogHook<RECORD>
    extends LogHookAdapter<RECORD> {
        private int count;

        public boolean accept(RECORD item) {
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static abstract class LogHookAdapter<RECORD>
    implements LogHook<RECORD> {
        @Override
        public void file(File file) {
        }

        @Override
        public void done(File file) {
        }
    }

    public static interface LogHook<RECORD>
    extends Predicate<RECORD> {
        public void file(File var1);

        public void done(File var1);
    }
}

