/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.rules.ExternalResource;
import org.neo4j.function.Consumer;
import org.neo4j.function.Functions;
import org.neo4j.function.RawFunction;
import org.neo4j.helpers.Cancelable;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.ConcurrentTransfer;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.Provider;
import org.neo4j.test.Barrier;

public class ThreadingRule
extends ExternalResource {
    private ExecutorService executor;

    protected void before() throws Throwable {
        this.executor = Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after() {
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.executor = null;
        }
    }

    public <FROM, TO, EX extends Exception> Future<TO> execute(RawFunction<FROM, TO, EX> function, FROM parameter) {
        return this.executor.submit(ThreadingRule.task(Barrier.NONE, function, parameter, (Consumer<Thread>)Functions.swallow(Thread.class)));
    }

    public <FROM, TO, EX extends Exception> Future<TO> executeAfter(Barrier barrier, RawFunction<FROM, TO, EX> function, FROM parameter) {
        return this.executor.submit(ThreadingRule.task(barrier, function, parameter, (Consumer<Thread>)Functions.swallow(Thread.class)));
    }

    public <FROM, TO, EX extends Exception> Future<TO> executeAndAwait(RawFunction<FROM, TO, EX> function, FROM parameter, Predicate<Thread> threadCondition, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        ConcurrentTransfer threadTransfer = new ConcurrentTransfer();
        Future<TO> future = this.executor.submit(ThreadingRule.task(Barrier.NONE, function, parameter, (Consumer<Thread>)threadTransfer));
        Predicates.await((Provider)threadTransfer, threadCondition, (long)timeout, (TimeUnit)unit);
        return future;
    }

    public Cancelable threadBlockMonitor(Thread thread, Runnable action) {
        CancellationHandle cancellation = new CancellationHandle();
        this.executor.submit(new ThreadBlockMonitor(cancellation, Objects.requireNonNull(thread, "thread"), Objects.requireNonNull(action, "action")));
        return cancellation;
    }

    private static <FROM, TO, EX extends Exception> Callable<TO> task(final Barrier barrier, final RawFunction<FROM, TO, EX> function, final FROM parameter, final Consumer<Thread> threadConsumer) {
        return new Callable<TO>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TO call() throws Exception {
                Thread thread = Thread.currentThread();
                String name = thread.getName();
                thread.setName(function.toString());
                threadConsumer.accept((Object)thread);
                barrier.reached();
                try {
                    Object object = function.apply(parameter);
                    return object;
                }
                finally {
                    thread.setName(name);
                }
            }
        };
    }

    public static Predicate<Thread> stackTracePredicate(final int depth, final Class<?> owner, final String method) {
        return new Predicate<Thread>(){

            public boolean accept(Thread thread) {
                StackTraceElement[] stackTrace = thread.getStackTrace();
                return stackTrace.length > depth && stackTrace[depth].getClassName().equals(owner.getName()) && stackTrace[depth].getMethodName().equals(method);
            }

            public String toString() {
                return String.format("Predicate[thread.getStackTrace()[%s] == %s.%s()]", depth, owner.getName(), method);
            }
        };
    }

    private static class ThreadBlockMonitor
    implements Runnable {
        private final CancellationRequest cancellation;
        private final Thread thread;
        private final Runnable action;

        public ThreadBlockMonitor(CancellationRequest cancellation, Thread thread, Runnable action) {
            this.cancellation = cancellation;
            this.thread = thread;
            this.action = action;
        }

        @Override
        public void run() {
            Object[] lastTrace = null;
            Thread.State lastState = null;
            do {
                Thread.State state = this.thread.getState();
                switch (state) {
                    case BLOCKED: 
                    case WAITING: 
                    case TIMED_WAITING: {
                        Object[] trace = this.thread.getStackTrace();
                        if (trace[0].isNativeMethod() && Thread.class.getName().equals(trace[0].getClassName()) && "sleep".equals(((StackTraceElement)trace[0]).getMethodName())) break;
                        if (lastState == state && Arrays.equals(trace, lastTrace)) {
                            this.action.run();
                            return;
                        }
                        lastTrace = trace;
                        break;
                    }
                    default: {
                        lastTrace = null;
                    }
                }
                lastState = state;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            } while (!this.cancellation.cancellationRequested());
        }
    }

    private static class CancellationHandle
    implements Cancelable,
    CancellationRequest {
        private volatile boolean cancelled = false;

        private CancellationHandle() {
        }

        public boolean cancellationRequested() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

