/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.subprocess;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.neo4j.helpers.Exceptions;
import org.neo4j.test.subprocess.BeforeDebuggedTest;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.KillSubProcess;
import org.neo4j.test.subprocess.SubProcess;
import org.neo4j.test.subprocess.SuspendedThreadsException;
import org.neo4j.test.subprocess.Task;

public class SubProcessTestRunner
extends BlockJUnit4ClassRunner {
    private final Map<String, BreakPoint> breakpoints = new HashMap<String, BreakPoint>();
    private volatile TestRunnerDispatcher dispatcher;
    private final Task.Executor taskExecutor = new Task.Executor(){

        @Override
        public void submit(final Task<?> task) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        SubProcessTestRunner.this.dispatcher.submit(task);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    };
    private static final Object TERMINATED = new Object();

    public SubProcessTestRunner(Class<?> test) throws InitializationError {
        super(test);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        for (FrameworkMethod handler : this.getTestClass().getAnnotatedMethods(BreakpointHandler.class)) {
            handler.validatePublicVoid(true, errors);
        }
        for (FrameworkMethod beforeDebugged : this.getTestClass().getAnnotatedMethods(BeforeDebuggedTest.class)) {
            beforeDebugged.validatePublicVoidNoArg(true, errors);
        }
    }

    private void startSubProcess(RunNotifier notifier) throws Throwable {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, this.getDescription());
        NotifierImpl remoteNotifier = new NotifierImpl(eachNotifier);
        this.dispatcher = (TestRunnerDispatcher)new TestProcess(this.getTestClass().getJavaClass().getName()).start(remoteNotifier, this.breakpoints());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSubProcess() {
        try {
            SubProcess.stop(this.dispatcher);
        }
        finally {
            this.dispatcher = null;
        }
    }

    protected Statement classBlock(final RunNotifier notifier) {
        final Statement children = this.childrenInvoker(notifier);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                SubProcessTestRunner.this.startSubProcess(notifier);
                try {
                    children.evaluate();
                }
                finally {
                    SubProcessTestRunner.this.stopSubProcess();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BreakPoint[] breakpoints() throws Throwable {
        if (this.breakpoints.isEmpty()) {
            Map<String, BreakPoint> map = this.breakpoints;
            synchronized (map) {
                if (this.breakpoints.isEmpty()) {
                    ArrayList<Exception> failures = new ArrayList<Exception>();
                    Object CLAIMED = new Object();
                    HashMap<String, Object> bpDefs = new HashMap<String, Object>();
                    ForeignBreakpoints foreign = this.getTestClass().getJavaClass().getAnnotation(ForeignBreakpoints.class);
                    if (foreign != null) {
                        for (ForeignBreakpoints.BreakpointDef def : foreign.value()) {
                            String name = def.name();
                            if (name.isEmpty()) {
                                name = def.method();
                            }
                            if (null == bpDefs.put(name, def)) continue;
                            failures.add(new Exception("Multiple definitions of the breakpoint \"" + name + "\""));
                        }
                    }
                    for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(BreakpointTrigger.class)) {
                        String name = ((BreakpointTrigger)method.getAnnotation(BreakpointTrigger.class)).value();
                        if (name.isEmpty()) {
                            name = method.getName();
                        }
                        if (null == bpDefs.put(name, method)) continue;
                        failures.add(new Exception("Multiple definitions of the breakpoint \"" + name + "\""));
                    }
                    for (FrameworkMethod handler : this.getTestClass().getAnnotatedMethods(BreakpointHandler.class)) {
                        for (String name : ((BreakpointHandler)handler.getAnnotation(BreakpointHandler.class)).value()) {
                            Object bp = bpDefs.get(name);
                            if (bp == null) {
                                failures.add(new Exception("No such breakpoint: \"" + name + "\", referenced from: " + handler));
                            } else if (bp == CLAIMED) {
                                failures.add(new Exception("Multiple handlers for breakpoint: \"" + name + "\", referenced from: " + handler));
                            } else if (bp instanceof ForeignBreakpoints.BreakpointDef) {
                                try {
                                    for (BreakpointDispatcher dispatch : this.createForeignBreakpoints((ForeignBreakpoints.BreakpointDef)bp, handler)) {
                                        this.breakpoints.put(name, dispatch);
                                    }
                                }
                                catch (Exception exc) {
                                    failures.add(exc);
                                }
                            } else if (bp instanceof FrameworkMethod) {
                                this.breakpoints.put(name, new BreakpointDispatcher(((BreakpointTrigger)((FrameworkMethod)bp).getAnnotation(BreakpointTrigger.class)).on(), ((FrameworkMethod)bp).getMethod().getDeclaringClass(), ((FrameworkMethod)bp).getMethod(), handler));
                            } else {
                                failures.add(new Exception("Internal error, unknown breakpoint def: " + bp));
                            }
                            bpDefs.put(name, CLAIMED);
                        }
                    }
                    if (bpDefs.size() != this.breakpoints.size()) {
                        for (Object bp : bpDefs.values()) {
                            if (bp == CLAIMED) continue;
                            failures.add(new Exception("Unhandled breakpoint: " + bp));
                        }
                    }
                    if (!failures.isEmpty()) {
                        if (failures.size() == 1) {
                            throw (Throwable)failures.get(0);
                        }
                        throw new MultipleFailureException(failures);
                    }
                }
            }
        }
        return this.breakpoints.values().toArray(new BreakPoint[this.breakpoints.size()]);
    }

    Iterable<BreakpointDispatcher> createForeignBreakpoints(ForeignBreakpoints.BreakpointDef def, FrameworkMethod handler) throws Exception {
        Class<?> type = Class.forName(def.type());
        ArrayList<BreakpointDispatcher> result = new ArrayList<BreakpointDispatcher>(1);
        for (Method method : type.getDeclaredMethods()) {
            if (!method.getName().equals(def.method())) continue;
            result.add(new BreakpointDispatcher(def.on(), type, method, handler));
        }
        if (result.isEmpty()) {
            throw new Exception("No such method: " + def);
        }
        return result;
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        Statement statement = new Statement(){

            public void evaluate() throws Throwable {
                SubProcessTestRunner.this.enableBreakpoints((EnabledBreakpoints)method.getAnnotation(EnabledBreakpoints.class));
                SubProcessTestRunner.this.dispatcher.run(method.getName());
            }
        };
        List befores = this.getTestClass().getAnnotatedMethods(BeforeDebuggedTest.class);
        if (!befores.isEmpty()) {
            statement = new RunBefores(statement, befores, null);
        }
        return statement;
    }

    private void enableBreakpoints(EnabledBreakpoints breakpoints) {
        HashSet<String> enabled = new HashSet<String>();
        if (breakpoints != null) {
            for (String name : breakpoints.value()) {
                enabled.add(name);
            }
        }
        for (Map.Entry<String, BreakPoint> entry : this.breakpoints.entrySet()) {
            BreakPoint bp = entry.getValue();
            (enabled.remove(entry.getKey()) ? bp.enable() : bp.disable()).resetInvocationCount();
        }
        if (!enabled.isEmpty()) {
            throw new IllegalArgumentException("Unknown breakpoints: " + enabled);
        }
    }

    private void verifyBreakpointState() throws SuspendedThreadsException {
        DebuggedThread[] threads;
        SubProcess.DebugDispatch debugger = SubProcess.DebugDispatch.get(this.dispatcher);
        DebuggedThread[] debuggedThreadArray = threads = debugger == null ? new DebuggedThread[]{} : debugger.suspendedThreads();
        if (threads.length != 0) {
            String[] names = new String[threads.length];
            for (int i = 0; i < threads.length; ++i) {
                names[i] = threads[i].name();
                threads[i].resume();
            }
            throw new SuspendedThreadsException(names);
        }
    }

    private static class RemoteTestRunner
    extends BlockJUnit4ClassRunner {
        private final TestProcess testProcess;
        private final RemoteRunNotifier host;
        private volatile Object testMethod;
        private volatile Object test;
        private Map<String, FrameworkMethod> methods;

        RemoteTestRunner(TestProcess testProcess, RemoteRunNotifier host, Class<?> test) throws InitializationError {
            super(test);
            this.testProcess = testProcess;
            this.host = host;
        }

        void terminate() {
            this.testMethod = TERMINATED;
        }

        protected Statement childrenInvoker(RunNotifier notifier) {
            return new Statement(){

                public void evaluate() {
                    RemoteTestRunner.this.testProcess.runner = (Object)RemoteTestRunner.this;
                    Object test = RemoteTestRunner.this.testMethod;
                    while (true) {
                        block6: {
                            if (test == null || test instanceof Throwable) {
                                try {
                                    Thread.sleep(1L);
                                    break block6;
                                }
                                catch (InterruptedException e) {
                                    RemoteTestRunner.this.testMethod = e;
                                    break;
                                }
                            }
                            if (!(test instanceof FrameworkMethod)) break;
                            try {
                                RemoteTestRunner.this.methodBlock((FrameworkMethod)test).evaluate();
                                RemoteTestRunner.this.testMethod = null;
                            }
                            catch (Throwable e) {
                                RemoteTestRunner.this.testMethod = e;
                            }
                        }
                        test = RemoteTestRunner.this.testMethod;
                    }
                }
            };
        }

        protected Statement methodBlock(FrameworkMethod method) {
            Statement statement = super.methodBlock(method);
            return statement;
        }

        protected Statement methodInvoker(FrameworkMethod method, Object test) {
            this.test = test;
            final Statement statement = super.methodInvoker(method, test);
            return new Statement(){

                public void evaluate() throws Throwable {
                    statement.evaluate();
                    RemoteTestRunner.this.host.checkPostConditions();
                }
            };
        }

        void run(String methodName) throws Throwable {
            if (this.methods == null) {
                HashMap<String, FrameworkMethod> map = new HashMap<String, FrameworkMethod>();
                for (FrameworkMethod method : this.getChildren()) {
                    map.put(method.getName(), method);
                }
                this.methods = map;
            }
            Object result = this.testMethod = this.methods.get(methodName);
            while (true) {
                if (!(result instanceof FrameworkMethod)) {
                    if (result instanceof Throwable) {
                        throw (Throwable)result;
                    }
                    return;
                }
                Thread.sleep(1L);
                result = this.testMethod;
            }
        }

        <T> void run(Task<T> task) {
            task.run(this.inject(RemoteTestRunner.typeOf(task)));
        }

        private <T> T inject(Class<T> type) {
            if (type == null) {
                return null;
            }
            Object test = this.test;
            if (type.isInstance(test)) {
                return type.cast(test);
            }
            return null;
        }

        private static <T> Class<T> typeOf(Task<T> task) {
            for (Class<?> taskType = task.getClass(); taskType != Object.class; taskType = taskType.getSuperclass()) {
                for (Type type : taskType.getGenericInterfaces()) {
                    Type param;
                    ParameterizedType paramType;
                    if (!(type instanceof ParameterizedType) || (paramType = (ParameterizedType)type).getRawType() != Task.class || (param = paramType.getActualTypeArguments()[0]).getClass() != Class.class) continue;
                    return (Class)param;
                }
            }
            return null;
        }
    }

    private static class TestProcess
    extends SubProcess<TestRunnerDispatcher, RemoteRunNotifier>
    implements TestRunnerDispatcher {
        private static final long serialVersionUID = 1L;
        private final String className;
        private volatile Object runner;

        public TestProcess(String className) {
            this.className = className;
        }

        @Override
        protected void startup(RemoteRunNotifier remote) throws Throwable {
            try {
                RunNotifier notifier = new RunNotifier();
                notifier.addListener((RunListener)new RemoteRunListener(remote));
                new RemoteTestRunner(this, remote, Class.forName(this.className)).run(notifier);
            }
            catch (Throwable failure) {
                this.runner = failure;
                throw failure;
            }
        }

        @Override
        public String toString() {
            return this.className.substring(this.className.lastIndexOf(46) + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void shutdown(boolean normal) {
            try {
                Object runner = this.runner;
                if (runner instanceof RemoteTestRunner) {
                    ((RemoteTestRunner)((Object)runner)).terminate();
                }
            }
            finally {
                this.runner = new RunTerminatedException();
            }
            super.shutdown(normal);
        }

        @Override
        public void run(String methodName) throws Throwable {
            this.runner().run(methodName);
        }

        @Override
        public void submit(Task<?> task) throws Throwable {
            this.runner().run(task);
        }

        private RemoteTestRunner runner() throws Throwable {
            Object runner = this.runner;
            while (!(runner instanceof RemoteTestRunner)) {
                if (runner instanceof Throwable) {
                    throw (Throwable)runner;
                }
                Thread.sleep(1L);
                runner = this.runner;
            }
            return (RemoteTestRunner)((Object)runner);
        }
    }

    public static class RunTerminatedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private RunTerminatedException() {
        }
    }

    private static class RemoteRunListener
    extends RunListener {
        private final RemoteRunNotifier remote;

        public RemoteRunListener(RemoteRunNotifier remote) {
            this.remote = remote;
        }

        public void testFailure(Failure failure) throws Exception {
            this.remote.failure(failure.getException());
        }
    }

    private class NotifierImpl
    extends UnicastRemoteObject
    implements RemoteRunNotifier {
        private static final long serialVersionUID = 1L;
        private final EachTestNotifier notifier;

        NotifierImpl(EachTestNotifier notifier) throws RemoteException {
            this.notifier = notifier;
        }

        @Override
        public void failure(Throwable exception) throws RemoteException {
            this.notifier.addFailure(exception);
        }

        @Override
        public void checkPostConditions() throws Throwable {
            SubProcessTestRunner.this.verifyBreakpointState();
        }
    }

    private static interface RemoteRunNotifier
    extends Remote {
        public void failure(Throwable var1) throws RemoteException;

        public void checkPostConditions() throws RemoteException, Throwable;
    }

    static interface TestRunnerDispatcher {
        public void submit(Task<?> var1) throws Throwable;

        public void run(String var1) throws Throwable;
    }

    private class BreakpointDispatcher
    extends BreakPoint {
        private final FrameworkMethod handler;

        BreakpointDispatcher(BreakPoint.Event event, Class<?> type, Method method, FrameworkMethod handler) {
            super(event, type, method.getName(), method.getParameterTypes());
            this.handler = handler;
        }

        @Override
        protected void callback(DebugInterface debug) throws KillSubProcess {
            Class<?>[] types = this.handler.getMethod().getParameterTypes();
            Annotation[][] annotations = this.handler.getMethod().getParameterAnnotations();
            Object[] params = new Object[types.length];
            block2: for (int i = 0; i < types.length; ++i) {
                if (types[i] == DebugInterface.class) {
                    params[i] = debug;
                    continue;
                }
                if (types[i] == BreakPoint.class) {
                    for (Annotation annotation : annotations[i]) {
                        String[] value;
                        if (!BreakpointHandler.class.isInstance(annotation) || (value = ((BreakpointHandler)annotation).value()).length != 1) continue;
                        params[i] = SubProcessTestRunner.this.breakpoints.get(value[0]);
                        continue block2;
                    }
                    params[i] = this;
                    continue;
                }
                params[i] = types[i] == Task.Executor.class ? SubProcessTestRunner.this.taskExecutor : null;
            }
            try {
                this.handler.invokeExplosively(null, params);
            }
            catch (Throwable exception) {
                throw (KillSubProcess)Exceptions.launderedException(KillSubProcess.class, (Throwable)exception);
            }
        }
    }
}

