/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.subprocess;

import java.util.Arrays;
import java.util.Iterator;

public class SuspendedThreadsException
extends Exception
implements Iterable<String> {
    private final String[] threadNames;

    SuspendedThreadsException(String ... threadNames) {
        super(SuspendedThreadsException.message(threadNames));
        this.threadNames = (String[])threadNames.clone();
    }

    private static String message(String[] threadName) {
        if (threadName == null || threadName.length == 0) {
            throw new IllegalArgumentException("No thread names given");
        }
        if (threadName.length == 1) {
            return "The \"" + threadName[0] + "\" thread is still suspended.";
        }
        StringBuilder message = new StringBuilder("The following threads are still suspended");
        String sep = ": ";
        for (String name : threadName) {
            message.append(sep).append('\"').append(name).append('\"');
            sep = ", ";
        }
        return message.toString();
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.threadNames).iterator();
    }
}

