/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.StoreLocker;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.TargetDirectory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class BatchInserterImplTest {
    @Test
    public void testHonorsPassedInParams() throws Exception {
        Long mappedMemoryTotalSize = this.createInserterAndGetMemoryMappingConfig(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.mapped_memory_total_size.name(), "16K"}));
        Assert.assertThat((String)"memory mapped config is active", (Object)mappedMemoryTotalSize, (Matcher)Matchers.is((Object)16384L));
    }

    @Test
    public void testCreatesStoreLockFile() {
        File file = TargetDirectory.forTest(this.getClass()).makeGraphDbDir();
        BatchInserter inserter = BatchInserters.inserter((String)file.getAbsolutePath());
        Assert.assertThat((Object)new File(file, "store_lock").exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailsOnExistingStoreLockFile() throws IOException {
        File parent = TargetDirectory.forTest(this.getClass()).makeGraphDbDir();
        StoreLocker lock = new StoreLocker((FileSystemAbstraction)new DefaultFileSystemAbstraction());
        lock.checkLock(parent);
        try {
            BatchInserters.inserter((String)parent.getAbsolutePath());
            Assert.fail();
        }
        catch (StoreLockException storeLockException) {
        }
        finally {
            lock.release();
        }
    }

    private Long createInserterAndGetMemoryMappingConfig(Map<String, String> initialConfig) throws Exception {
        BatchInserter inserter = BatchInserters.inserter((String)TargetDirectory.forTest(this.getClass()).makeGraphDbDir().getAbsolutePath(), initialConfig);
        NeoStore neoStore = ReflectionUtil.getPrivateField(inserter, "neoStore", NeoStore.class);
        Config config = ReflectionUtil.getPrivateField(neoStore, "conf", Config.class);
        inserter.shutdown();
        return (Long)config.get(GraphDatabaseSettings.mapped_memory_total_size);
    }
}

