/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.graphdb.Direction;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLinkImpl;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class NodeRelationshipLinkImplTest {
    private Random random;

    @Test
    public void shouldReportCorrectNumberOfDenseNodes() throws Exception {
        NodeRelationshipLinkImpl cache = new NodeRelationshipLinkImpl(NumberArrayFactory.AUTO, 5);
        this.increment((NodeRelationshipLink)cache, 2L, 10);
        this.increment((NodeRelationshipLink)cache, 5L, 2);
        this.increment((NodeRelationshipLink)cache, 7L, 12);
        this.increment((NodeRelationshipLink)cache, 23L, 4);
        this.increment((NodeRelationshipLink)cache, 24L, 5);
        this.increment((NodeRelationshipLink)cache, 25L, 6);
        Assert.assertFalse((boolean)cache.isDense(0L));
        Assert.assertTrue((boolean)cache.isDense(2L));
        Assert.assertFalse((boolean)cache.isDense(5L));
        Assert.assertTrue((boolean)cache.isDense(7L));
        Assert.assertFalse((boolean)cache.isDense(23L));
        Assert.assertTrue((boolean)cache.isDense(24L));
        Assert.assertTrue((boolean)cache.isDense(25L));
    }

    @Test
    public void shouldGoThroughThePhases() throws Exception {
        int nodeCount = 10;
        NodeRelationshipLinkImpl link = new NodeRelationshipLinkImpl(NumberArrayFactory.OFF_HEAP, 20);
        this.incrementRandomCounts((NodeRelationshipLink)link, nodeCount, nodeCount * 20);
        long node = this.findNode((NodeRelationshipLink)link, nodeCount, false);
        this.testNode((NodeRelationshipLink)link, node, -1, null);
        node = this.findNode((NodeRelationshipLink)link, nodeCount, true);
        this.testNode((NodeRelationshipLink)link, node, 4, Direction.OUTGOING);
        this.testNode((NodeRelationshipLink)link, node, 4, Direction.INCOMING);
        this.testNode((NodeRelationshipLink)link, node, 2, Direction.OUTGOING);
    }

    @Test
    public void shouldAddGroupAfterTheFirst() throws Exception {
        long denseNode = 0L;
        NodeRelationshipLinkImpl link = new NodeRelationshipLinkImpl(NumberArrayFactory.AUTO, 1);
        link.incrementCount(denseNode);
        link.getAndPutRelationship(denseNode, 0, Direction.OUTGOING, 0L, true);
        link.getAndPutRelationship(denseNode, 1, Direction.INCOMING, 1L, true);
        link.getAndPutRelationship(denseNode, 0, Direction.INCOMING, 2L, true);
        link.getAndPutRelationship(denseNode, 1, Direction.OUTGOING, 3L, true);
        NodeRelationshipLink.GroupVisitor visitor = (NodeRelationshipLink.GroupVisitor)Mockito.mock(NodeRelationshipLink.GroupVisitor.class);
        Assert.assertEquals((long)0L, (long)link.getFirstRel(denseNode, visitor));
        InOrder order = Mockito.inOrder((Object[])new Object[]{visitor});
        ((NodeRelationshipLink.GroupVisitor)order.verify((Object)visitor)).visit(denseNode, 0, 1L, 0L, 2L, -1L);
        ((NodeRelationshipLink.GroupVisitor)order.verify((Object)visitor)).visit(denseNode, 1, -1L, 3L, 1L, -1L);
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAddGroupBeforeTheFirst() throws Exception {
        long denseNode = 0L;
        NodeRelationshipLinkImpl link = new NodeRelationshipLinkImpl(NumberArrayFactory.AUTO, 1);
        link.incrementCount(denseNode);
        link.getAndPutRelationship(denseNode, 1, Direction.INCOMING, 1L, true);
        link.getAndPutRelationship(denseNode, 0, Direction.OUTGOING, 0L, true);
        link.getAndPutRelationship(denseNode, 0, Direction.INCOMING, 2L, true);
        link.getAndPutRelationship(denseNode, 1, Direction.OUTGOING, 3L, true);
        NodeRelationshipLink.GroupVisitor visitor = (NodeRelationshipLink.GroupVisitor)Mockito.mock(NodeRelationshipLink.GroupVisitor.class);
        Assert.assertEquals((long)0L, (long)link.getFirstRel(denseNode, visitor));
        InOrder order = Mockito.inOrder((Object[])new Object[]{visitor});
        ((NodeRelationshipLink.GroupVisitor)order.verify((Object)visitor)).visit(denseNode, 0, 1L, 0L, 2L, -1L);
        ((NodeRelationshipLink.GroupVisitor)order.verify((Object)visitor)).visit(denseNode, 1, -1L, 3L, 1L, -1L);
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAddGroupInTheMiddleIfTwo() throws Exception {
        long denseNode = 0L;
        NodeRelationshipLinkImpl link = new NodeRelationshipLinkImpl(NumberArrayFactory.AUTO, 1);
        link.incrementCount(denseNode);
        link.getAndPutRelationship(denseNode, 0, Direction.OUTGOING, 0L, true);
        link.getAndPutRelationship(denseNode, 2, Direction.OUTGOING, 1L, true);
        link.getAndPutRelationship(denseNode, 1, Direction.INCOMING, 2L, true);
        link.getAndPutRelationship(denseNode, 0, Direction.INCOMING, 3L, true);
        link.getAndPutRelationship(denseNode, 1, Direction.OUTGOING, 4L, true);
        link.getAndPutRelationship(denseNode, 2, Direction.INCOMING, 5L, true);
        link.getAndPutRelationship(denseNode, 1, Direction.BOTH, 6L, true);
        NodeRelationshipLink.GroupVisitor visitor = (NodeRelationshipLink.GroupVisitor)Mockito.mock(NodeRelationshipLink.GroupVisitor.class);
        Assert.assertEquals((long)0L, (long)link.getFirstRel(denseNode, visitor));
        ((NodeRelationshipLink.GroupVisitor)Mockito.verify((Object)visitor)).visit(denseNode, 0, 2L, 0L, 3L, -1L);
        ((NodeRelationshipLink.GroupVisitor)Mockito.verify((Object)visitor)).visit(denseNode, 1, 1L, 4L, 2L, 6L);
        ((NodeRelationshipLink.GroupVisitor)Mockito.verify((Object)visitor)).visit(denseNode, 2, -1L, 1L, 5L, -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    private void testNode(NodeRelationshipLink link, long node, int type, Direction direction) {
        int count = link.getCount(node, type, direction);
        Assert.assertEquals((long)-1L, (long)link.getAndPutRelationship(node, type, direction, 5L, false));
        Assert.assertEquals((long)5L, (long)link.getAndPutRelationship(node, type, direction, 10L, false));
        Assert.assertEquals((long)count, (long)link.getCount(node, type, direction));
    }

    private long findNode(NodeRelationshipLink link, long nodeCount, boolean isDense) {
        for (long i = 0L; i < nodeCount; ++i) {
            if (link.isDense(i) != isDense) continue;
            return i;
        }
        throw new IllegalArgumentException("No dense node found");
    }

    private int incrementRandomCounts(NodeRelationshipLink link, int nodeCount, int i) {
        int highestSeenCount = 0;
        while (i-- > 0) {
            long node = this.random.nextInt(nodeCount);
            highestSeenCount = Math.max(highestSeenCount, link.incrementCount(node));
        }
        return highestSeenCount;
    }

    @Before
    public void before() {
        long seed = System.currentTimeMillis();
        this.random = new Random(seed);
    }

    private void increment(NodeRelationshipLink cache, long node, int count) {
        for (int i = 0; i < count; ++i) {
            cache.incrementCount(node);
        }
    }
}

