/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.unsafe.impl.batchimport.cache.AvailableMemoryCalculator;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapLongArray;

public class NumberArrayFactoryTest {
    private static final int KILO = 1024;
    private static final long MEGA = 0x100000L;

    @Test
    public void shouldAllocateOnHeapIfAvailable() throws Exception {
        AvailableMemoryCalculator memory = (AvailableMemoryCalculator)Mockito.mock(AvailableMemoryCalculator.class);
        Mockito.when((Object)memory.availableHeapMemory()).thenReturn((Object)0xA00000L);
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(memory, 10240L);
        LongArray array = factory.newLongArray(1024L, 0L);
        array.set(1014L, 12345L);
        Assert.assertTrue((boolean)(array instanceof HeapLongArray));
        Assert.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    public void shouldAllocateOffHeapIfNotEnoughHeapAvailable() throws Exception {
        AvailableMemoryCalculator memory = (AvailableMemoryCalculator)Mockito.mock(AvailableMemoryCalculator.class);
        Mockito.when((Object)memory.availableHeapMemory()).thenReturn((Object)0x100000L);
        Mockito.when((Object)memory.availableOffHeapMemory()).thenReturn((Object)0xA00000L);
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(memory, 10240L);
        LongArray array = factory.newLongArray(0x100000L, 0L);
        array.set(1048566L, 12345L);
        Assert.assertTrue((boolean)(array instanceof OffHeapLongArray));
        Assert.assertEquals((long)12345L, (long)array.get(1048566L));
    }

    @Test
    public void shouldAllocateDynamicGrowingInBothHeapAndOffHeapIfEnoughCollectiveMemoryAvailable() throws Exception {
        AvailableMemoryCalculator memory = (AvailableMemoryCalculator)Mockito.mock(AvailableMemoryCalculator.class);
        Mockito.when((Object)memory.availableHeapMemory()).thenReturn((Object)0x500000L);
        Mockito.when((Object)memory.availableOffHeapMemory()).thenReturn((Object)0x500000L);
        NumberArrayFactory.Auto factory = new NumberArrayFactory.Auto(memory, 10240L);
        LongArray array = factory.newLongArray(0x100000L, 0L);
        array.set(1048566L, 12345L);
        Assert.assertTrue((boolean)(array instanceof DynamicLongArray));
        Assert.assertEquals((long)12345L, (long)array.get(1048566L));
    }
}

