/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.test.RepeatRule;
import org.neo4j.unsafe.impl.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.LongEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringEncoder;

public class EncodingIdMapperTest {
    private final long seed = System.currentTimeMillis();
    private final Random random = new Random(this.seed);
    @Rule
    public final RepeatRule repeater = new RepeatRule();

    @Test
    public void shouldHandleGreatAmountsOfStuff() throws Exception {
        IdMapper idMapper = IdMappers.strings((NumberArrayFactory)NumberArrayFactory.AUTO);
        ResourceIterable<Object> ids = new ResourceIterable<Object>(){

            public ResourceIterator<Object> iterator() {
                return new PrefetchingResourceIterator<Object>(){
                    private int i;

                    protected Object fetchNextOrNull() {
                        return this.i++ < 300000 ? "" + this.i : null;
                    }

                    public void close() {
                    }
                };
            }
        };
        long index = 0L;
        for (Object id : ids) {
            idMapper.put(id, index++);
        }
        idMapper.prepare((ResourceIterable)ids);
        GatheringMemoryStatsVisitor memoryStats = new GatheringMemoryStatsVisitor();
        idMapper.visitMemoryStats((MemoryStatsVisitor)memoryStats);
        for (Object id : ids) {
            if (idMapper.get(id) != -1L) continue;
            Assert.fail((String)("Couldn't find " + id + " even though I added it just previously"));
        }
    }

    @Test
    public void shouldReturnExpectedValueForNotFound() throws Exception {
        IdMapper idMapper = IdMappers.strings((NumberArrayFactory)NumberArrayFactory.AUTO);
        idMapper.prepare(null);
        long id = idMapper.get((Object)"123");
        Assert.assertEquals((long)-1L, (long)id);
    }

    @Test
    public void shouldEncodeShortStrings() throws Exception {
        IdMapper mapper = IdMappers.strings((NumberArrayFactory)NumberArrayFactory.AUTO);
        mapper.put((Object)"123", 0L);
        mapper.put((Object)"456", 1L);
        mapper.prepare(null);
        Assert.assertEquals((long)1L, (long)mapper.get((Object)"456"));
        Assert.assertEquals((long)0L, (long)mapper.get((Object)"123"));
    }

    @RepeatRule.Repeat(times=10)
    @Test
    public void shouldEncodeSmallSetOfRandomData() throws Throwable {
        Object value;
        int processorsForSorting = this.random.nextInt(7) + 1;
        int size = this.random.nextInt(10000) + 2;
        ValueType type = ValueType.values()[this.random.nextInt(ValueType.values().length)];
        EncodingIdMapper mapper = new EncodingIdMapper(NumberArrayFactory.HEAP, type.encoder(), type.radix(), size * 2, processorsForSorting);
        ValueGenerator values = new ValueGenerator(size, type.data(this.random));
        int id = 0;
        Iterator i$ = values.iterator();
        while (i$.hasNext()) {
            value = i$.next();
            mapper.put(value, (long)id++);
        }
        try {
            mapper.prepare((ResourceIterable)values);
            id = 0;
            i$ = values.iterator();
            while (i$.hasNext()) {
                value = i$.next();
                Assert.assertEquals((String)("Expected " + value + " to map to " + id + ", seed:" + this.seed), (long)id++, (long)mapper.get(value));
            }
        }
        catch (Throwable e) {
            throw Exceptions.withMessage((Throwable)e, (String)(e.getMessage() + ", seed:" + this.seed));
        }
    }

    @Test
    public void shouldRefuseCollisionsBasedOnSameInputId() throws Exception {
        EncodingIdMapper mapper = new EncodingIdMapper(NumberArrayFactory.HEAP, (Encoder)new StringEncoder(), (Radix)new Radix.String());
        ResourceIterable ids = IteratorUtil.resourceIterable(Arrays.asList("10", "9", "10"));
        try (ResourceIterator iterator = ids.iterator();){
            int i = 0;
            while (iterator.hasNext()) {
                mapper.put(iterator.next(), (long)i);
                ++i;
            }
        }
        try {
            mapper.prepare(ids);
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("10"));
        }
    }

    @Test
    public void shouldCopyWithCollisionsBasedOnDifferentInputIds() throws Exception {
        Encoder encoder = (Encoder)Mockito.mock(Encoder.class);
        Mockito.when((Object)encoder.encode(Matchers.any())).thenReturn((Object)12345L);
        EncodingIdMapper mapper = new EncodingIdMapper(NumberArrayFactory.HEAP, encoder, (Radix)new Radix.String());
        ResourceIterable ids = IteratorUtil.resourceIterable(Arrays.asList("10", "9"));
        try (ResourceIterator iterator = ids.iterator();){
            int i = 0;
            while (iterator.hasNext()) {
                mapper.put(iterator.next(), (long)i);
                ++i;
            }
        }
        mapper.prepare(ids);
        Assert.assertEquals((long)0L, (long)mapper.get((Object)"10"));
        Assert.assertEquals((long)1L, (long)mapper.get((Object)"9"));
    }

    private static enum ValueType {
        LONGS{

            @Override
            Encoder encoder() {
                return new LongEncoder();
            }

            @Override
            Radix radix() {
                return new Radix.Long();
            }

            @Override
            Factory<Object> data(final Random random) {
                return new Factory<Object>(){

                    public Object newInstance() {
                        return random.nextInt(1000000000);
                    }
                };
            }
        }
        ,
        LONGS_AS_STRINGS{

            @Override
            Encoder encoder() {
                return new StringEncoder();
            }

            @Override
            Radix radix() {
                return new Radix.String();
            }

            @Override
            Factory<Object> data(final Random random) {
                return new Factory<Object>(){

                    public Object newInstance() {
                        return String.valueOf(random.nextInt(1000000000));
                    }
                };
            }
        }
        ,
        VERY_LONG_STRINGS{
            char[] CHARS = "\u00bd!\"#\u00a4%&/()=?`\u00b4;:,._-<>".toCharArray();

            @Override
            Encoder encoder() {
                return new StringEncoder();
            }

            @Override
            Radix radix() {
                return new Radix.String();
            }

            @Override
            Factory<Object> data(final Random random) {
                return new Factory<Object>(){

                    public Object newInstance() {
                        int length = 1500;
                        for (int i = 0; i < 4; ++i) {
                            length = random.nextInt(length) + 20;
                        }
                        char[] chars = new char[length];
                        for (int i = 0; i < length; ++i) {
                            char ch = random.nextBoolean() ? this.randomLetter(random) : CHARS[random.nextInt(CHARS.length)];
                            chars[i] = ch;
                        }
                        return new String(chars);
                    }

                    private char randomLetter(Random random2) {
                        int base = random2.nextBoolean() ? 97 : 65;
                        int size = 25;
                        return (char)(base + random2.nextInt(size));
                    }
                };
            }
        };


        abstract Encoder encoder();

        abstract Radix radix();

        abstract Factory<Object> data(Random var1);
    }

    private class ValueGenerator
    implements ResourceIterable<Object> {
        private final int size;
        private final Factory<Object> generator;
        private final List<Object> values = new ArrayList<Object>();
        private final Set<Object> deduper = new HashSet<Object>();

        ValueGenerator(int size, Factory<Object> generator) {
            this.size = size;
            this.generator = generator;
        }

        public ResourceIterator<Object> iterator() {
            if (!this.values.isEmpty()) {
                return IteratorUtil.resourceIterator(this.values.iterator(), (Resource)Resource.EMPTY);
            }
            return IteratorUtil.resourceIterator((Iterator)new PrefetchingIterator<Object>(){
                private int cursor;

                protected Object fetchNextOrNull() {
                    if (this.cursor < ValueGenerator.this.size) {
                        Object value;
                        do {
                            value = ValueGenerator.this.generator.newInstance();
                        } while (!ValueGenerator.this.deduper.add(value));
                        ValueGenerator.this.values.add(value);
                        ++this.cursor;
                        return value;
                    }
                    return null;
                }
            }, (Resource)Resource.EMPTY);
        }
    }
}

