/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.csv.reader.BufferedCharSeeker;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Readables;
import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.TargetDirectory;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.Data;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class CsvInputTest {
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final Extractors extractors = new Extractors(',');

    @Test
    public void shouldProvideNodesFromCsvInput() throws Exception {
        IdType idType = IdType.ACTUAL;
        Iterable data = this.dataIterable(this.data("123,Mattias Persson,HACKER"));
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, idType.extractor(this.extractors)), this.entry("name", Type.PROPERTY, this.extractors.string()), this.entry("labels", Type.LABEL, this.extractors.string())), null, null, idType, Configuration.COMMAS);
        ResourceIterator nodes = input.nodes().iterator();
        this.assertNode((InputNode)nodes.next(), 123L, this.properties("name", "Mattias Persson"), this.labels("HACKER"));
        Assert.assertFalse((boolean)nodes.hasNext());
    }

    @Test
    public void shouldProvideRelationshipsFromCsvInput() throws Exception {
        IdType idType = IdType.STRING;
        Iterable data = this.dataIterable(this.data("node1,node2,KNOWS,1234567\nnode2,node10,HACKS,987654"));
        CsvInput input = new CsvInput(null, null, data, this.header(this.entry("from", Type.START_ID, idType.extractor(this.extractors)), this.entry("to", Type.END_ID, idType.extractor(this.extractors)), this.entry("type", Type.TYPE, this.extractors.string()), this.entry("since", Type.PROPERTY, (Extractor<?>)this.extractors.long_())), idType, Configuration.COMMAS);
        ResourceIterator relationships = input.relationships().iterator();
        this.assertRelationship((InputRelationship)relationships.next(), 0L, "node1", "node2", "KNOWS", this.properties("since", 1234567L));
        this.assertRelationship((InputRelationship)relationships.next(), 1L, "node2", "node10", "HACKS", this.properties("since", 987654L));
    }

    @Test
    public void shouldCloseDataIteratorsInTheEnd() throws Exception {
        CharSeeker nodeData = (CharSeeker)Mockito.spy((Object)this.charSeeker("test"));
        CharSeeker relationshipData = (CharSeeker)Mockito.spy((Object)this.charSeeker("test"));
        IdType idType = IdType.STRING;
        Iterable nodeDataIterable = this.dataIterable(this.given(nodeData));
        Iterable relationshipDataIterable = this.dataIterable(this.given(relationshipData));
        CsvInput input = new CsvInput(nodeDataIterable, this.header(this.entry("single", Type.IGNORE, idType.extractor(this.extractors))), relationshipDataIterable, this.header(this.entry("single", Type.IGNORE, idType.extractor(this.extractors))), idType, Configuration.COMMAS);
        try (ResourceIterator iterator = input.nodes().iterator();){
            iterator.next();
        }
        iterator = input.relationships().iterator();
        var8_8 = null;
        try {
            iterator.next();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var8_8 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable x2) {
                        var8_8.addSuppressed(x2);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        ((CharSeeker)Mockito.verify((Object)nodeData, (VerificationMode)Mockito.times((int)1))).close();
        ((CharSeeker)Mockito.verify((Object)relationshipData, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldCopeWithLinesThatHasTooFewValuesButStillValidates() throws Exception {
        Iterable data = this.dataIterable(this.data("1,ultralisk,ZERG,10\n2,corruptor,ZERG\n3,mutalisk,ZERG,3"));
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, (Extractor<?>)this.extractors.long_()), this.entry("unit", Type.PROPERTY, this.extractors.string()), this.entry("type", Type.LABEL, this.extractors.string()), this.entry("kills", Type.PROPERTY, (Extractor<?>)this.extractors.int_())), null, null, IdType.ACTUAL, Configuration.COMMAS);
        try (ResourceIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"unit", "ultralisk", "kills", 10}, this.labels("ZERG"));
            this.assertNode((InputNode)nodes.next(), 2L, new Object[]{"unit", "corruptor"}, this.labels("ZERG"));
            this.assertNode((InputNode)nodes.next(), 3L, new Object[]{"unit", "mutalisk", "kills", 3}, this.labels("ZERG"));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldIgnoreValuesAfterHeaderEntries() throws Exception {
        Iterable data = this.dataIterable(this.data("1,zergling,bubble,bobble\n2,scv,pun,intended"));
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, (Extractor<?>)this.extractors.long_()), this.entry("name", Type.PROPERTY, this.extractors.string())), null, null, IdType.ACTUAL, Configuration.COMMAS);
        try (ResourceIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"name", "zergling"}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), 2L, new Object[]{"name", "scv"}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldHandleMultipleInputGroups() throws Exception {
        DataFactory group1 = this.data(":ID,name,kills:int,health:int\n1,Jim,10,100\n2,Abathur,0,200\n");
        DataFactory group2 = this.data(":ID,type\n3,zergling\n4,csv\n");
        Iterable data = this.dataIterable(group1, group2);
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.STRING, Configuration.COMMAS);
        ResourceIterator nodes = input.nodes().iterator();
        this.assertNode((InputNode)nodes.next(), "1", this.properties("name", "Jim", "kills", 10, "health", 100), this.labels(new String[0]));
        this.assertNode((InputNode)nodes.next(), "2", this.properties("name", "Abathur", "kills", 0, "health", 200), this.labels(new String[0]));
        this.assertNode((InputNode)nodes.next(), "3", this.properties("type", "zergling"), this.labels(new String[0]));
        this.assertNode((InputNode)nodes.next(), "4", this.properties("type", "csv"), this.labels(new String[0]));
        Assert.assertFalse((boolean)nodes.hasNext());
    }

    @Test
    public void shouldProvideAdditiveLabels() throws Exception {
        Object[] addedLabels = new String[]{"Two", "AddTwo"};
        DataFactory data = this.data(":ID,name,:LABEL\n0,First,\n1,Second,One\n2,Third,One;Two", InputEntityDecorators.additiveLabels((String[])addedLabels));
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.ACTUAL, Configuration.COMMAS);
        try (ResourceIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 0L, this.properties("name", "First"), this.labels((String[])addedLabels));
            this.assertNode((InputNode)nodes.next(), 1L, this.properties("name", "Second"), this.labels((String[])ArrayUtil.union((Object[])new String[]{"One"}, (Object[])addedLabels)));
            this.assertNode((InputNode)nodes.next(), 2L, this.properties("name", "Third"), this.labels((String[])ArrayUtil.union((Object[])new String[]{"One"}, (Object[])addedLabels)));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldProvideDefaultRelationshipType() throws Exception {
        String defaultType = "DEFAULT";
        String customType = "CUSTOM";
        DataFactory data = this.data(":START_ID,:END_ID,:TYPE\n0,1,\n1,2," + customType + "\n" + "2,1," + defaultType, InputEntityDecorators.defaultRelationshipType((String)defaultType));
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(null, null, dataIterable, DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, Configuration.COMMAS);
        try (ResourceIterator relationships = input.relationships().iterator();){
            this.assertRelationship((InputRelationship)relationships.next(), 0L, 0L, 1L, defaultType, InputEntity.NO_PROPERTIES);
            this.assertRelationship((InputRelationship)relationships.next(), 1L, 1L, 2L, customType, InputEntity.NO_PROPERTIES);
            this.assertRelationship((InputRelationship)relationships.next(), 2L, 2L, 1L, defaultType, InputEntity.NO_PROPERTIES);
            Assert.assertFalse((boolean)relationships.hasNext());
        }
    }

    @Test
    public void shouldAllowNodesWithoutIdHeader() throws Exception {
        DataFactory data = this.data("name:string,level:int\nMattias,1\nJohan,2\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.STRING, Configuration.COMMAS);
        try (ResourceIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), null, new Object[]{"name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), null, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldAllowSomeNodesToBeAnonymous() throws Exception {
        DataFactory data = this.data(":ID,name:string,level:int\nabc,Mattias,1\n,Johan,2\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.STRING, Configuration.COMMAS);
        try (ResourceIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), "abc", new Object[]{"name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), null, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldAllowNodesToBeAnonymousEvenIfIdHeaderIsNamed() throws Exception {
        DataFactory data = this.data("id:ID,name:string,level:int\nabc,Mattias,1\n,Johan,2\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.STRING, Configuration.COMMAS);
        try (ResourceIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), "abc", new Object[]{"id", "abc", "name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), null, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldHaveIdSetAsPropertyIfIdHeaderEntryIsNamed() throws Exception {
        DataFactory data = this.data("myId:ID,name:string,level:int\nabc,Mattias,1\ndef,Johan,2\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.STRING, Configuration.COMMAS);
        try (ResourceIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), "abc", new Object[]{"myId", "abc", "name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), "def", new Object[]{"myId", "def", "name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldNotHaveIdSetAsPropertyIfIdHeaderEntryIsNamedForActualIds() throws Exception {
        DataFactory data = this.data("myId:ID,name:string,level:int\n0,Mattias,1\n1,Johan,2\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.ACTUAL, Configuration.COMMAS);
        try (ResourceIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 0L, new Object[]{"name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldIgnoreEmptyPropertyValues() throws Exception {
        DataFactory data = this.data(":ID,name,extra\n0,Mattias,\n1,Johan,Additional\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.ACTUAL, Configuration.COMMAS);
        try (ResourceIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 0L, new Object[]{"name", "Mattias"}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"name", "Johan", "extra", "Additional"}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldIgnoreEmptyIntPropertyValues() throws Exception {
        DataFactory data = this.data(":ID,name,extra:int\n0,Mattias,\n1,Johan,10\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.ACTUAL, Configuration.COMMAS);
        try (ResourceIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 0L, new Object[]{"name", "Mattias"}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"name", "Johan", "extra", 10}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldFailOnArrayDelimiterBeingSameAsDelimiter() throws Exception {
        try {
            new CsvInput(null, null, null, null, IdType.ACTUAL, this.customConfig(',', ',', '\"'));
            Assert.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("array delimiter"));
        }
    }

    @Test
    public void shouldFailOnQuotationCharacterBeingSameAsDelimiter() throws Exception {
        try {
            new CsvInput(null, null, null, null, IdType.ACTUAL, this.customConfig(',', ';', ','));
            Assert.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("delimiter"));
            Assert.assertTrue((boolean)e.getMessage().contains("quotation"));
        }
    }

    @Test
    public void shouldFailOnQuotationCharacterBeingSameAsArrayDelimiter() throws Exception {
        try {
            new CsvInput(null, null, null, null, IdType.ACTUAL, this.customConfig(',', ';', ';'));
            Assert.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("array delimiter"));
            Assert.assertTrue((boolean)e.getMessage().contains("quotation"));
        }
    }

    private Configuration customConfig(final char delimiter, final char arrayDelimiter, final char quote) {
        return new Configuration(){

            public char quotationCharacter() {
                return quote;
            }

            public char delimiter() {
                return delimiter;
            }

            public char arrayDelimiter() {
                return arrayDelimiter;
            }
        };
    }

    private <ENTITY extends InputEntity> DataFactory<ENTITY> given(final CharSeeker data) {
        return new DataFactory<ENTITY>(){

            public Data<ENTITY> create(Configuration config) {
                return CsvInputTest.this.noDecoratorData(data, Functions.identity());
            }
        };
    }

    private <ENTITY extends InputEntity> Data<ENTITY> noDecoratorData(final CharSeeker data, final Function<ENTITY, ENTITY> decorator) {
        return new Data<ENTITY>(){

            public CharSeeker stream() {
                return data;
            }

            public Function<ENTITY, ENTITY> decorator() {
                return decorator;
            }
        };
    }

    private void assertRelationship(InputRelationship relationship, long id, Object startNode, Object endNode, String type, Object[] properties) {
        Assert.assertEquals((long)id, (long)relationship.id());
        Assert.assertEquals((Object)startNode, (Object)relationship.startNode());
        Assert.assertEquals((Object)endNode, (Object)relationship.endNode());
        Assert.assertEquals((Object)type, (Object)relationship.type());
        Assert.assertArrayEquals((Object[])properties, (Object[])relationship.properties());
    }

    private void assertNode(InputNode node, Object id, Object[] properties, Set<String> labels) {
        Assert.assertEquals((Object)id, (Object)node.id());
        Assert.assertArrayEquals((Object[])properties, (Object[])node.properties());
        Assert.assertEquals(labels, (Object)IteratorUtil.asSet((Object[])node.labels()));
    }

    private Object[] properties(Object ... keysAndValues) {
        return keysAndValues;
    }

    private Set<String> labels(String ... labels) {
        return IteratorUtil.asSet((Object[])labels);
    }

    private Header.Factory header(final Header.Entry ... entries) {
        return new Header.Factory(){

            public Header create(CharSeeker from, Configuration configuration, IdType idType) {
                return new Header(entries);
            }
        };
    }

    private Header.Entry entry(String name, Type type, Extractor<?> extractor) {
        return new Header.Entry(name, type, extractor);
    }

    private <ENTITY extends InputEntity> DataFactory<ENTITY> data(String data) {
        return this.data(data, Functions.identity());
    }

    private <ENTITY extends InputEntity> DataFactory<ENTITY> data(final String data, final Function<ENTITY, ENTITY> decorator) {
        return new DataFactory<ENTITY>(){

            public Data<ENTITY> create(Configuration config) {
                return CsvInputTest.this.noDecoratorData(CsvInputTest.this.charSeeker(data), decorator);
            }
        };
    }

    private CharSeeker charSeeker(String data) {
        return new BufferedCharSeeker(Readables.wrap((Reader)new StringReader(data)));
    }

    private <ENTITY extends InputEntity> Iterable<DataFactory<ENTITY>> dataIterable(DataFactory ... data) {
        return Iterables.iterable((Object[])data);
    }
}

