/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.Reader;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.csv.reader.BufferedCharSeeker;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Readables;
import org.neo4j.function.Factory;
import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.unsafe.impl.batchimport.input.DuplicateHeaderException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class DataFactoriesTest {
    @Test
    public void shouldParseDefaultNodeFileHeaderCorrectly() throws Exception {
        BufferedCharSeeker seeker = new BufferedCharSeeker(Readables.wrap((Reader)new StringReader("ID:ID,label-one:label,also-labels:LABEL,name,age:long")));
        IdType idType = IdType.STRING;
        Extractors extractors = new Extractors(',');
        Header header = DataFactories.defaultFormatNodeFileHeader().create((CharSeeker)seeker, Configuration.COMMAS, idType);
        Assert.assertArrayEquals((Object[])IteratorUtil.array((Object[])new Header.Entry[]{this.entry("ID", Type.ID, idType.extractor(extractors)), this.entry("label-one", Type.LABEL, extractors.stringArray()), this.entry("also-labels", Type.LABEL, extractors.stringArray()), this.entry("name", Type.PROPERTY, extractors.string()), this.entry("age", Type.PROPERTY, (Extractor<?>)extractors.long_())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldParseDefaultRelationshipFileHeaderCorrectly() throws Exception {
        BufferedCharSeeker seeker = new BufferedCharSeeker(Readables.wrap((Reader)new StringReader(":START_ID\t:END_ID\ttype:TYPE\tdate:long\tmore:long[]")));
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        Header header = DataFactories.defaultFormatRelationshipFileHeader().create((CharSeeker)seeker, Configuration.TABS, idType);
        Assert.assertArrayEquals((Object[])IteratorUtil.array((Object[])new Header.Entry[]{this.entry(null, Type.START_ID, idType.extractor(extractors)), this.entry(null, Type.END_ID, idType.extractor(extractors)), this.entry("type", Type.TYPE, extractors.string()), this.entry("date", Type.PROPERTY, (Extractor<?>)extractors.long_()), this.entry("more", Type.PROPERTY, extractors.longArray())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldHaveEmptyHeadersBeInterpretedAsIgnored() throws Exception {
        BufferedCharSeeker seeker = new BufferedCharSeeker(Readables.wrap((Reader)new StringReader("one:id\ttwo\t\tdate:long")));
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        Header header = DataFactories.defaultFormatNodeFileHeader().create((CharSeeker)seeker, Configuration.TABS, idType);
        Assert.assertArrayEquals((Object[])IteratorUtil.array((Object[])new Header.Entry[]{this.entry("one", Type.ID, (Extractor<?>)extractors.long_()), this.entry("two", Type.PROPERTY, extractors.string()), this.entry(null, Type.IGNORE, null), this.entry("date", Type.PROPERTY, (Extractor<?>)extractors.long_())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldFailForDuplicatePropertyHeaderEntries() throws Exception {
        BufferedCharSeeker seeker = new BufferedCharSeeker(Readables.wrap((Reader)new StringReader("one:id\tname\tname:long")));
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        try {
            DataFactories.defaultFormatNodeFileHeader().create((CharSeeker)seeker, Configuration.TABS, idType);
            Assert.fail((String)"Should fail");
        }
        catch (DuplicateHeaderException e) {
            Assert.assertEquals((Object)this.entry("name", Type.PROPERTY, extractors.string()), (Object)e.getFirst());
            Assert.assertEquals((Object)this.entry("name", Type.PROPERTY, (Extractor<?>)extractors.long_()), (Object)e.getOther());
        }
        seeker.close();
    }

    @Test
    public void shouldFailForDuplicateIdHeaderEntries() throws Exception {
        BufferedCharSeeker seeker = new BufferedCharSeeker(Readables.wrap((Reader)new StringReader("one:id\ttwo:id")));
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        try {
            DataFactories.defaultFormatNodeFileHeader().create((CharSeeker)seeker, Configuration.TABS, idType);
            Assert.fail((String)"Should fail");
        }
        catch (DuplicateHeaderException e) {
            Assert.assertEquals((Object)this.entry("one", Type.ID, (Extractor<?>)extractors.long_()), (Object)e.getFirst());
            Assert.assertEquals((Object)this.entry("two", Type.ID, (Extractor<?>)extractors.long_()), (Object)e.getOther());
        }
        seeker.close();
    }

    @Test
    public void shouldAllowMissingIdHeaderEntry() throws Exception {
        BufferedCharSeeker seeker = new BufferedCharSeeker(Readables.wrap((Reader)new StringReader("one\ttwo")));
        Extractors extractors = new Extractors(';');
        Header header = DataFactories.defaultFormatNodeFileHeader().create((CharSeeker)seeker, Configuration.TABS, IdType.ACTUAL);
        Assert.assertArrayEquals((Object[])IteratorUtil.array((Object[])new Header.Entry[]{this.entry("one", Type.PROPERTY, extractors.string()), this.entry("two", Type.PROPERTY, extractors.string())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldParseHeaderFromSeparateReader() throws Exception {
        CharSeeker dataSeeker = (CharSeeker)Mockito.mock(CharSeeker.class);
        Header.Factory headerFactory = DataFactories.defaultFormatNodeFileHeader((CharReadable)Readables.wrap((Reader)new StringReader("id:ID\tname:String\tbirth_date:long")));
        Extractors extractors = new Extractors(';');
        Header header = headerFactory.create(dataSeeker, Configuration.TABS, IdType.ACTUAL);
        Assert.assertArrayEquals((Object[])IteratorUtil.array((Object[])new Header.Entry[]{this.entry("id", Type.ID, (Extractor<?>)extractors.long_()), this.entry("name", Type.PROPERTY, extractors.string()), this.entry("birth_date", Type.PROPERTY, (Extractor<?>)extractors.long_())}), (Object[])header.entries());
        Mockito.verifyZeroInteractions((Object[])new Object[]{dataSeeker});
        dataSeeker.close();
    }

    @Test
    public void shouldParseHeaderFromFirstLineOfFirstInputFile() throws Exception {
        final CharReadable firstSource = Readables.wrap((Reader)new StringReader("id:ID\tname:String\tbirth_date:long"));
        final CharReadable secondSource = Readables.wrap((Reader)new StringReader("0\tThe node\t123456789"));
        DataFactory dataFactory = DataFactories.data((Function)Functions.identity(), (Factory)new Factory<CharReadable>(){

            public CharReadable newInstance() {
                return Readables.multipleSources((CharReadable[])new CharReadable[]{firstSource, secondSource});
            }
        });
        Header.Factory headerFactory = DataFactories.defaultFormatNodeFileHeader();
        Extractors extractors = new Extractors(';');
        CharSeeker seeker = dataFactory.create(Configuration.TABS).stream();
        Header header = headerFactory.create(seeker, Configuration.TABS, IdType.ACTUAL);
        Assert.assertArrayEquals((Object[])IteratorUtil.array((Object[])new Header.Entry[]{this.entry("id", Type.ID, (Extractor<?>)extractors.long_()), this.entry("name", Type.PROPERTY, extractors.string()), this.entry("birth_date", Type.PROPERTY, (Extractor<?>)extractors.long_())}), (Object[])header.entries());
        seeker.close();
    }

    private Header.Entry entry(String name, Type type, Extractor<?> extractor) {
        return new Header.Entry(name, type, extractor);
    }
}

