/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class ControlledStep<T>
implements Step<T>,
StatsProvider {
    private final String name;
    private final Map<Key, ControlledStat> stats = new HashMap<Key, ControlledStat>();
    private final boolean allowMultipleProcessors;
    private volatile int numberOfProcessors = 1;

    public static Step<?> stepWithAverageOf(long avg) {
        ControlledStep step = new ControlledStep("test", true);
        step.setStat((Key)Keys.avg_processing_time, avg);
        return step;
    }

    public static Step<?> stepWithStats(Map<Key, Long> statistics) {
        ControlledStep step = new ControlledStep("test", true);
        for (Map.Entry<Key, Long> statistic : statistics.entrySet()) {
            step.setStat(statistic.getKey(), statistic.getValue());
        }
        return step;
    }

    public static Step<?> stepWithStats(Object ... statisticsAltKeyAndValue) {
        return ControlledStep.stepWithStats(MapUtil.genericMap((Object[])statisticsAltKeyAndValue));
    }

    public ControlledStep(String name, boolean allowMultipleProcessors) {
        this.name = name;
        this.allowMultipleProcessors = allowMultipleProcessors;
    }

    public int numberOfProcessors() {
        return this.numberOfProcessors;
    }

    public synchronized boolean incrementNumberOfProcessors() {
        if (!this.allowMultipleProcessors) {
            return false;
        }
        ++this.numberOfProcessors;
        return true;
    }

    public synchronized boolean decrementNumberOfProcessors() {
        if (this.numberOfProcessors == 1) {
            return false;
        }
        --this.numberOfProcessors;
        return true;
    }

    public String name() {
        return this.name;
    }

    public long receive(long ticket, T batch) {
        throw new UnsupportedOperationException("Cannot participate in actual processing yet");
    }

    public void setStat(Key key, long value) {
        this.stats.put(key, new ControlledStat(value));
    }

    public StepStats stats() {
        return new StepStats(this.name, !this.isCompleted(), Arrays.asList(this));
    }

    public void endOfUpstream() {
    }

    public boolean isCompleted() {
        return false;
    }

    public void setDownstream(Step<?> downstreamStep) {
    }

    public void receivePanic(Throwable cause) {
    }

    public void close() {
    }

    public Stat stat(Key key) {
        return this.stats.get(key);
    }

    public void start() {
    }

    public Key[] keys() {
        return this.stats.keySet().toArray(new Key[this.stats.size()]);
    }

    private static class ControlledStat
    implements Stat {
        private final long value;

        ControlledStat(long value) {
            this.value = value;
        }

        public DetailLevel detailLevel() {
            return DetailLevel.BASIC;
        }

        public long asLong() {
            return this.value;
        }
    }
}

