/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ControlledStep;
import org.neo4j.unsafe.impl.batchimport.staging.DynamicProcessorAssigner;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public class DynamicProcessorAssignerTest {
    @Test
    public void shouldAssignAdditionalCPUToBottleNeckStep() throws Exception {
        Configuration config = this.movingAverageConfig(10);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config, 5);
        ControlledStep slowStep = new ControlledStep("slow", true);
        slowStep.setStat((Key)Keys.avg_processing_time, 10L);
        slowStep.setStat((Key)Keys.done_batches, 10L);
        ControlledStep fastStep = new ControlledStep("fast", true);
        fastStep.setStat((Key)Keys.avg_processing_time, 2L);
        fastStep.setStat((Key)Keys.done_batches, 10L);
        StageExecution[] execution = this.executionOf(config, slowStep, fastStep);
        assigner.start(execution);
        assigner.check(execution);
        Assert.assertEquals((long)5L, (long)slowStep.numberOfProcessors());
        Assert.assertEquals((long)1L, (long)fastStep.numberOfProcessors());
    }

    @Test
    public void shouldRemoveCPUsFromWayTooFastStep() throws Exception {
        Configuration config = this.movingAverageConfig(10);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config, 2);
        ControlledStep slowStep = (ControlledStep)Mockito.spy(new ControlledStep("slow", true));
        slowStep.setStat((Key)Keys.avg_processing_time, 10L);
        slowStep.setStat((Key)Keys.done_batches, 10L);
        ControlledStep fastStep = (ControlledStep)Mockito.spy(new ControlledStep("fast", true));
        fastStep.setStat((Key)Keys.avg_processing_time, 2L);
        fastStep.setStat((Key)Keys.done_batches, 10L);
        StageExecution[] execution = this.executionOf(config, slowStep, fastStep);
        assigner.start(execution);
        assigner.check(execution);
        ((ControlledStep)Mockito.verify((Object)slowStep, (VerificationMode)Mockito.times((int)1))).incrementNumberOfProcessors();
        ((ControlledStep)Mockito.verify((Object)fastStep, (VerificationMode)Mockito.times((int)1))).decrementNumberOfProcessors();
        slowStep.setStat((Key)Keys.done_batches, 25L);
        fastStep.setStat((Key)Keys.done_batches, 25L);
        assigner.check(execution);
        ((ControlledStep)Mockito.verify((Object)slowStep, (VerificationMode)Mockito.times((int)0))).decrementNumberOfProcessors();
        ((ControlledStep)Mockito.verify((Object)fastStep, (VerificationMode)Mockito.times((int)1))).decrementNumberOfProcessors();
    }

    @Test
    public void shouldHandleZeroAverage() throws Exception {
        Configuration config = this.movingAverageConfig(10);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config, 5);
        ControlledStep aStep = new ControlledStep("slow", true);
        aStep.setStat((Key)Keys.avg_processing_time, 0L);
        aStep.setStat((Key)Keys.done_batches, 0L);
        ControlledStep anotherStep = new ControlledStep("fast", true);
        anotherStep.setStat((Key)Keys.avg_processing_time, 0L);
        anotherStep.setStat((Key)Keys.done_batches, 0L);
        StageExecution[] execution = this.executionOf(config, aStep, anotherStep);
        assigner.start(execution);
        assigner.check(execution);
        Assert.assertEquals((long)1L, (long)aStep.numberOfProcessors());
        Assert.assertEquals((long)1L, (long)anotherStep.numberOfProcessors());
    }

    private Configuration movingAverageConfig(final int movingAverage) {
        return new Configuration.Default(){

            public int movingAverageSize() {
                return movingAverage;
            }
        };
    }

    private StageExecution[] executionOf(Configuration config, Step<?> ... steps) {
        StageExecution execution = new StageExecution("Test", config, Arrays.asList(steps));
        return new StageExecution[]{execution};
    }
}

