/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.unsafe.impl.batchimport.staging.AbstractExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisor;
import org.neo4j.unsafe.impl.batchimport.staging.MultiExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public class MultiExecutionMonitorTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Test
    public void shouldCheckMultipleMonitors() throws Exception {
        FakeClock clock = new FakeClock();
        TestableMonitor first = new TestableMonitor(clock, 100L, TimeUnit.MILLISECONDS);
        TestableMonitor other = new TestableMonitor(clock, 250L, TimeUnit.MILLISECONDS);
        MultiExecutionMonitor multiMonitor = new MultiExecutionMonitor((Clock)clock, new ExecutionMonitor[]{first, other});
        StageExecution execution = (StageExecution)Mockito.mock(StageExecution.class);
        Mockito.when((Object)execution.stillExecuting()).thenReturn((Object)true);
        OtherThreadExecutor<Object> t2 = this.cleanup.add(new OtherThreadExecutor<Object>("T2", null));
        Future<Object> future = t2.executeDontWait(this.monitor(clock, (ExecutionMonitor)multiMonitor, execution));
        clock.forward(110L, TimeUnit.MILLISECONDS);
        this.awaitChecks(new Object[]{first, 1, other, 0});
        clock.forward(100L, TimeUnit.MILLISECONDS);
        this.awaitChecks(new Object[]{first, 2, other, 0});
        clock.forward(45L, TimeUnit.MILLISECONDS);
        this.awaitChecks(new Object[]{first, 2, other, 1});
        Mockito.when((Object)execution.stillExecuting()).thenReturn((Object)false);
        future.get();
    }

    private void awaitChecks(Object ... alternatingMonitorAndCount) {
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(2L);
        while (System.currentTimeMillis() < endTime) {
            boolean match = true;
            for (int i = 0; i < alternatingMonitorAndCount.length; ++i) {
                TestableMonitor monitor = (TestableMonitor)((Object)alternatingMonitorAndCount[i++]);
                int count = (Integer)alternatingMonitorAndCount[i];
                Assert.assertThat((Object)monitor.timesPolled, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(count)));
                if (monitor.timesPolled >= count) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return;
        }
        Assert.fail((String)"Polls didn't occur");
    }

    private OtherThreadExecutor.WorkerCommand<Void, Object> monitor(final Clock clock, final ExecutionMonitor multiMonitor, final StageExecution execution) {
        return new OtherThreadExecutor.WorkerCommand<Void, Object>(){

            @Override
            public Object doWork(Void state) throws Exception {
                new ExecutionSupervisor(clock, multiMonitor).supervise(new StageExecution[]{execution});
                return null;
            }
        };
    }

    private static class TestableMonitor
    extends AbstractExecutionMonitor {
        private int timesPolled;

        public TestableMonitor(Clock clock, long interval, TimeUnit unit) {
            super(clock, interval, unit);
        }

        public void check(StageExecution[] executions) {
            ++this.timesPolled;
        }
    }
}

