/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ControlledStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public class StageExecutionTest {
    @Test
    public void shouldOrderStepsAscending() throws Exception {
        ArrayList steps = new ArrayList();
        steps.add(ControlledStep.stepWithAverageOf(10L));
        steps.add(ControlledStep.stepWithAverageOf(5L));
        steps.add(ControlledStep.stepWithAverageOf(30L));
        StageExecution execution = new StageExecution("Test", Configuration.DEFAULT, steps);
        Iterator ordered = execution.stepsOrderedBy((Key)Keys.avg_processing_time, true).iterator();
        Pair fastest = (Pair)ordered.next();
        Assert.assertEquals((float)0.5f, (float)((Float)fastest.other()).floatValue(), (float)0.0f);
        Pair faster = (Pair)ordered.next();
        Assert.assertEquals((float)0.33333334f, (float)((Float)faster.other()).floatValue(), (float)0.0f);
        Pair fast = (Pair)ordered.next();
        Assert.assertEquals((float)1.0f, (float)((Float)fast.other()).floatValue(), (float)0.0f);
        Assert.assertFalse((boolean)ordered.hasNext());
    }

    @Test
    public void shouldOrderStepsDescending() throws Exception {
        ArrayList steps = new ArrayList();
        steps.add(ControlledStep.stepWithAverageOf(10L));
        steps.add(ControlledStep.stepWithAverageOf(5L));
        steps.add(ControlledStep.stepWithAverageOf(30L));
        steps.add(ControlledStep.stepWithAverageOf(5L));
        StageExecution execution = new StageExecution("Test", Configuration.DEFAULT, steps);
        Iterator ordered = execution.stepsOrderedBy((Key)Keys.avg_processing_time, false).iterator();
        Pair slowest = (Pair)ordered.next();
        Assert.assertEquals((float)3.0f, (float)((Float)slowest.other()).floatValue(), (float)0.0f);
        Pair slower = (Pair)ordered.next();
        Assert.assertEquals((float)2.0f, (float)((Float)slower.other()).floatValue(), (float)0.0f);
        Pair slow = (Pair)ordered.next();
        Assert.assertEquals((float)1.0f, (float)((Float)slow.other()).floatValue(), (float)0.0f);
        Pair alsoSlow = (Pair)ordered.next();
        Assert.assertEquals((float)1.0f, (float)((Float)alsoSlow.other()).floatValue(), (float)0.0f);
        Assert.assertFalse((boolean)ordered.hasNext());
    }
}

