/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.test.TargetDirectory;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class BatchingPageCacheTest {
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final FileSystemAbstraction FS = new DefaultFileSystemAbstraction();
    private final int recordSize = 15;
    private final int recordsPerPage = 6;

    @Test
    public void shouldAppendThroughMultiplePages() throws Exception {
        int numberOfRecords = 100;
        BatchingPageCache pageCache = new BatchingPageCache(this.FS, numberOfRecords, BatchingPageCache.SYNCHRONOUS, Monitor.NO_MONITOR, BatchingPageCache.Mode.APPEND_ONLY);
        File file = this.directory.file("store");
        PagedFile pagedFile = pageCache.map(file, 90);
        try (PageCursor cursor = pagedFile.io(0L, 0);){
            cursor.next();
            for (int i = 0; i < numberOfRecords; ++i) {
                if (i > 0 && i % 6 == 0) {
                    cursor.next();
                }
                this.writeRecord(cursor, i);
            }
        }
        pageCache.close();
        this.assertRecordsAreCorrect(file, numberOfRecords);
    }

    @Test
    public void shouldReadAndUpdateExistingContentsInUpdateMode() throws Exception {
        int pageSize = 100;
        File file = this.directory.file("store");
        this.fillFileWithByteContents(file);
        BatchingPageCache pageCache = new BatchingPageCache(this.FS, pageSize, BatchingPageCache.SYNCHRONOUS, Monitor.NO_MONITOR, BatchingPageCache.Mode.UPDATE);
        PagedFile pagedFile = pageCache.map(file, pageSize);
        for (int p = 0; p <= 1; ++p) {
            try (PageCursor cursor = pagedFile.io((long)p, 0);){
                cursor.next();
                for (int i = 0; i < pageSize; ++i) {
                    int offset = cursor.getOffset();
                    byte value = cursor.getByte();
                    if (i % 3 != 0) continue;
                    cursor.setOffset(offset);
                    value = (byte)(value + 1);
                    cursor.putByte(value);
                }
                continue;
            }
        }
        pageCache.close();
        this.assertByteContentsAreCorrect(file);
    }

    @Test
    public void shouldWriteChangesBeforeMovingWindow() throws Exception {
        byte[] someBytes = new byte[]{1, 2, 3, 4, 5};
        byte[] someOtherBytes = new byte[]{6, 7, 8, 9, 10};
        int pageSize = 100;
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        File file = this.directory.file("store");
        this.fillFileWithByteContents(file);
        BatchingPageCache pageCache = new BatchingPageCache(this.FS, pageSize, BatchingPageCache.SYNCHRONOUS, monitor, BatchingPageCache.Mode.APPEND_ONLY);
        PagedFile pagedFile = pageCache.map(file, pageSize);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            cursor.putBytes(someBytes);
        }
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)0))).dataWritten(0);
        cursor = pagedFile.io(0L, 2);
        var9_9 = null;
        try {
            cursor.setOffset(16);
            cursor.putBytes(someBytes);
        }
        catch (Throwable x2) {
            var9_9 = x2;
            throw x2;
        }
        finally {
            if (cursor != null) {
                if (var9_9 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable x2) {
                        var9_9.addSuppressed(x2);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)0))).dataWritten(0);
        var9_9 = null;
        try (PageCursor ignored = pagedFile.io(1L, 2);){
            ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).dataWritten(Matchers.anyInt());
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldZeroOutBufferBetweenUses() throws Exception {
        int pageSize = 100;
        File file = this.directory.file("store");
        this.fillFileWithByteContents(file);
        byte[] someBytes = new byte[]{1, 2, 3, 4, 5};
        BatchingPageCache pageCache = new BatchingPageCache(this.FS, pageSize, BatchingPageCache.SYNCHRONOUS, Monitor.NO_MONITOR, BatchingPageCache.Mode.APPEND_ONLY);
        PagedFile pagedFile = pageCache.map(file, pageSize);
        try (PageCursor cursor = pagedFile.io(1L, 2);){
            cursor.putBytes(someBytes);
        }
        cursor = pagedFile.io(2L, 2);
        var7_7 = null;
        try {
            byte[] readBack = new byte[someBytes.length];
            cursor.getBytes(readBack);
            byte[] zeros = new byte[someBytes.length];
            Arrays.fill(zeros, (byte)0);
            Assert.assertArrayEquals((byte[])zeros, (byte[])readBack);
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var7_7 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable x2) {
                        var7_7.addSuppressed(x2);
                    }
                } else {
                    cursor.close();
                }
            }
        }
    }

    private void assertByteContentsAreCorrect(File file) throws IOException {
        try (StoreChannel channel = this.FS.open(file, "r");){
            ByteBuffer buffer = ByteBuffer.allocate(255);
            int read = channel.read(buffer);
            Assert.assertEquals((long)buffer.capacity(), (long)read);
            buffer.flip();
            int counter = 0;
            for (int i = 0; i <= 1; ++i) {
                for (int j = 0; j < 100; ++j) {
                    byte value = buffer.get();
                    byte expectedValue = (byte)counter++;
                    if (j % 3 == 0) {
                        expectedValue = (byte)(expectedValue + 1);
                    }
                    Assert.assertEquals((long)expectedValue, (long)value);
                }
            }
        }
    }

    private void fillFileWithByteContents(File file) throws IOException {
        try (StoreChannel channel = this.FS.open(file, "rw");){
            ByteBuffer buffer = ByteBuffer.allocate(256);
            for (int i = 0; i < buffer.capacity(); ++i) {
                buffer.put((byte)i);
            }
            buffer.flip();
            channel.write(buffer);
        }
    }

    private void assertRecordsAreCorrect(File file, int numberOfRecords) throws IOException {
        try (StoreChannel channel = this.FS.open(file, "r");){
            ByteBuffer buffer = ByteBuffer.allocate(15);
            for (int i = 0; i < numberOfRecords; ++i) {
                buffer.clear();
                channel.read(buffer);
                buffer.flip();
                this.assertRecord(i, buffer);
            }
        }
    }

    private void assertRecord(int i, ByteBuffer buffer) {
        Assert.assertEquals((long)i, (long)buffer.getLong());
        int length = 7;
        byte[] readBytes = new byte[length];
        buffer.get(readBytes);
        Assert.assertArrayEquals((byte[])this.bytesStartingAt(length, i), (byte[])readBytes);
    }

    private void writeRecord(PageCursor cursor, int index) {
        cursor.putLong((long)index);
        cursor.putBytes(this.bytesStartingAt(7, index));
    }

    private byte[] bytesStartingAt(int length, int start) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(start + i);
        }
        return bytes;
    }
}

