/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store.io;

import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.pool.Pool;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.util.SimplePool;
import org.neo4j.unsafe.impl.batchimport.executor.DynamicTaskExecutor;
import org.neo4j.unsafe.impl.batchimport.executor.TaskExecutor;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.io.IoQueue;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class IoQueueTest {
    private TaskExecutor executor;
    private IoQueue queue;
    private final Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
    private final ByteBuffer buffer = ByteBuffer.allocate(10);

    @Test
    public void shouldExecuteWriteJob() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        BatchingPageCache.Writer writer = this.queue.create(channel, this.monitor);
        SimplePool pool = (SimplePool)Mockito.mock(SimplePool.class);
        int position = 100;
        writer.write(this.buffer, (long)position, (Pool)pool);
        this.executor.shutdown(true);
        ((TaskExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).submit((Callable)Matchers.any(Callable.class));
        ((StoreChannel)Mockito.verify((Object)channel)).write(this.buffer, 100L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel});
    }

    @Test
    public void shouldExecuteWriteJobsForMultipleFiles() throws Exception {
        StoreChannel channel1 = (StoreChannel)Mockito.mock(StoreChannel.class);
        StoreChannel channel2 = (StoreChannel)Mockito.mock(StoreChannel.class);
        BatchingPageCache.Writer writer1 = this.queue.create(channel1, this.monitor);
        BatchingPageCache.Writer writer2 = this.queue.create(channel2, this.monitor);
        SimplePool pool1 = (SimplePool)Mockito.mock(SimplePool.class);
        SimplePool pool2 = (SimplePool)Mockito.mock(SimplePool.class);
        int position1 = 100;
        int position2 = 100 + this.buffer.capacity();
        int position3 = 50;
        writer1.write(this.buffer, 100L, (Pool)pool1);
        writer1.write(this.buffer, (long)position2, (Pool)pool1);
        writer2.write(this.buffer, 50L, (Pool)pool2);
        this.executor.shutdown(true);
        ((TaskExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.atLeast((int)2))).submit((Callable)Matchers.any(Callable.class));
        ((TaskExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.atMost((int)3))).submit((Callable)Matchers.any(Callable.class));
        this.executor.shutdown(true);
        ((StoreChannel)Mockito.verify((Object)channel1)).write(this.buffer, 100L);
        ((StoreChannel)Mockito.verify((Object)channel1)).write(this.buffer, (long)position2);
        ((StoreChannel)Mockito.verify((Object)channel2)).write(this.buffer, 50L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel2});
    }

    @Before
    public void before() {
        this.executor = (TaskExecutor)Mockito.spy((Object)new DynamicTaskExecutor(3, 20, DynamicTaskExecutor.DEFAULT_PARK_STRATEGY, this.getClass().getSimpleName()));
        this.queue = new IoQueue(this.executor, 3, BatchingPageCache.SYNCHRONOUS);
    }

    @After
    public void after() {
        this.queue.shutdown();
    }
}

