/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.LogRotationControl;

public class LogRotationImpl
implements LogRotation {
    private final LogRotation.Monitor monitor;
    private final LogFile logFile;
    private final LogRotationControl logRotationControl;

    public LogRotationImpl(LogRotation.Monitor monitor, LogFile logFile, LogRotationControl logRotationControl) {
        this.monitor = monitor;
        this.logFile = logFile;
        this.logRotationControl = logRotationControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rotateLogIfNeeded() throws IOException {
        if (this.logFile.rotationNeeded()) {
            boolean rotated;
            LogFile logFile = this.logFile;
            synchronized (logFile) {
                rotated = this.logFile.rotationNeeded();
                if (rotated) {
                    this.doRotate();
                }
            }
            if (rotated) {
                this.monitor.rotatedLog();
            }
            return rotated;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotateLogFile() throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.doRotate();
        }
        this.monitor.rotatedLog();
    }

    private void doRotate() throws IOException {
        this.logRotationControl.awaitAllTransactionsClosed();
        this.logRotationControl.forceEverything();
        this.logFile.rotate();
    }
}

