/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class TransactionRepresentationCommitProcess
implements TransactionCommitProcess {
    private final LogicalTransactionStore logicalTransactionStore;
    private final KernelHealth kernelHealth;
    private final TransactionIdStore transactionIdStore;
    private final TransactionRepresentationStoreApplier storeApplier;
    private final TransactionApplicationMode mode;

    public TransactionRepresentationCommitProcess(LogicalTransactionStore logicalTransactionStore, KernelHealth kernelHealth, TransactionIdStore transactionIdStore, TransactionRepresentationStoreApplier storeApplier, TransactionApplicationMode mode) {
        this.logicalTransactionStore = logicalTransactionStore;
        this.transactionIdStore = transactionIdStore;
        this.kernelHealth = kernelHealth;
        this.storeApplier = storeApplier;
        this.mode = mode;
    }

    @Override
    public long commit(TransactionRepresentation transaction, LockGroup locks) throws TransactionFailureException {
        long transactionId = this.commitTransaction(transaction);
        try {
            this.storeApplier.apply(transaction, locks, transactionId, this.mode);
        }
        catch (Throwable e) {
            throw this.exception(Status.Transaction.CouldNotCommit, e, "Could not apply the transaction to the store after written to log");
        }
        finally {
            this.transactionIdStore.transactionClosed(transactionId);
        }
        return transactionId;
    }

    private TransactionFailureException exception(Status status, Throwable cause, String message) {
        this.kernelHealth.panic(cause);
        return new TransactionFailureException(status, cause, message, new Object[0]);
    }

    private long commitTransaction(TransactionRepresentation tx) throws TransactionFailureException {
        try {
            return this.logicalTransactionStore.getAppender().append(tx);
        }
        catch (Throwable e) {
            throw this.exception(Status.Transaction.CouldNotWriteToLog, e, "Could not append transaction representation to log");
        }
    }
}

