/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.EnumMap;
import java.util.Map;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectVisitor;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.SingleChainPosition;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.util.RelIdArray;

public class DenseNodeChainPosition
implements RelationshipLoadingPosition {
    private final PrimitiveIntObjectMap<RelationshipLoadingPosition> positions = Primitive.intObjectMap();
    private final int[] types;
    private RelationshipLoadingPosition currentPosition;

    public DenseNodeChainPosition(Map<Integer, RelationshipGroupRecord> groups) {
        this.types = PrimitiveIntCollections.asArray(groups.keySet());
        for (Map.Entry<Integer, RelationshipGroupRecord> entry : groups.entrySet()) {
            this.positions.put(entry.getKey().intValue(), (Object)new TypePosition(entry.getValue()));
        }
    }

    private DenseNodeChainPosition(final DenseNodeChainPosition copyFrom) {
        copyFrom.positions.visitEntries((PrimitiveIntObjectVisitor)new PrimitiveIntObjectVisitor<RelationshipLoadingPosition, RuntimeException>(){

            public boolean visited(int type, RelationshipLoadingPosition originalPosition) {
                RelationshipLoadingPosition position = originalPosition.clone();
                DenseNodeChainPosition.this.positions.put(type, (Object)position);
                if (originalPosition == copyFrom.currentPosition) {
                    DenseNodeChainPosition.this.currentPosition = position;
                }
                return false;
            }
        });
        this.types = copyFrom.types;
    }

    @Override
    public long position(RelIdArray.DirectionWrapper direction, int[] types) {
        if (types.length == 0) {
            types = this.types;
        }
        for (int type : types) {
            RelationshipLoadingPosition position = this.getTypePosition(type);
            if (!position.hasMore(direction, types)) continue;
            this.currentPosition = position;
            return position.position(direction, types);
        }
        return Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    private RelationshipLoadingPosition getTypePosition(int type) {
        RelationshipLoadingPosition position = (RelationshipLoadingPosition)this.positions.get(type);
        if (position == null) {
            return RelationshipLoadingPosition.EMPTY;
        }
        return position;
    }

    @Override
    public long nextPosition(long nextPosition, RelIdArray.DirectionWrapper direction, int[] types) {
        this.currentPosition.nextPosition(nextPosition, direction, types);
        if (nextPosition != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return nextPosition;
        }
        return this.position(direction, types);
    }

    @Override
    public boolean hasMore(RelIdArray.DirectionWrapper direction, int[] types) {
        if (types.length == 0) {
            types = this.types;
        }
        for (int type : types) {
            RelationshipLoadingPosition position = (RelationshipLoadingPosition)this.positions.get(type);
            if (position == null || !position.hasMore(direction, types)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean atPosition(RelIdArray.DirectionWrapper direction, int type, long position) {
        RelationshipLoadingPosition typePosition = (RelationshipLoadingPosition)this.positions.get(type);
        return typePosition != null ? typePosition.atPosition(direction, type, position) : false;
    }

    @Override
    public void compareAndAdvance(RelIdArray.DirectionWrapper direction, int type, long relIdDeleted, long nextRelId) {
        this.getTypePosition(type).compareAndAdvance(direction, type, relIdDeleted, nextRelId);
    }

    @Override
    public RelationshipLoadingPosition clone() {
        return new DenseNodeChainPosition(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName() + ":");
        builder.append(String.format("%n  positions: %s", this.positions));
        return builder.toString();
    }

    private static class TypePosition
    implements RelationshipLoadingPosition {
        private final EnumMap<RelIdArray.DirectionWrapper, RelationshipLoadingPosition> directions = new EnumMap(RelIdArray.DirectionWrapper.class);
        private RelationshipLoadingPosition currentPosition;

        TypePosition(RelationshipGroupRecord record) {
            RelIdArray.DirectionWrapper[] arr$ = RelIdArray.DirectionWrapper.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                RelIdArray.DirectionWrapper direction;
                long firstRel = (direction = arr$[i$]).getNextRel(record);
                this.directions.put(direction, firstRel != (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? new SingleChainPosition(firstRel) : RelationshipLoadingPosition.EMPTY);
            }
        }

        private TypePosition(TypePosition copyFrom) {
            for (Map.Entry<RelIdArray.DirectionWrapper, RelationshipLoadingPosition> entry : copyFrom.directions.entrySet()) {
                RelationshipLoadingPosition position = entry.getValue().clone();
                this.directions.put((RelIdArray.DirectionWrapper)((Enum)entry.getKey()), position);
                if (entry.getValue() != copyFrom.currentPosition) continue;
                this.currentPosition = position;
            }
        }

        @Override
        public boolean atPosition(RelIdArray.DirectionWrapper direction, int type, long position) {
            return this.directions.get((Object)direction).atPosition(direction, type, position);
        }

        @Override
        public long position(RelIdArray.DirectionWrapper direction, int[] types) {
            if (direction == RelIdArray.DirectionWrapper.BOTH) {
                for (RelationshipLoadingPosition position : this.directions.values()) {
                    if (!position.hasMore(direction, types)) continue;
                    this.currentPosition = position;
                    return position.position(direction, types);
                }
            } else {
                for (RelIdArray.DirectionWrapper dir : new RelIdArray.DirectionWrapper[]{direction, RelIdArray.DirectionWrapper.BOTH}) {
                    RelationshipLoadingPosition position = this.directions.get((Object)dir);
                    if (!position.hasMore(dir, types)) continue;
                    this.currentPosition = position;
                    return position.position(dir, types);
                }
            }
            return Record.NO_NEXT_RELATIONSHIP.intValue();
        }

        @Override
        public long nextPosition(long position, RelIdArray.DirectionWrapper direction, int[] types) {
            this.currentPosition.nextPosition(position, direction, types);
            if (position != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                return position;
            }
            return this.position(direction, types);
        }

        @Override
        public boolean hasMore(RelIdArray.DirectionWrapper direction, int[] types) {
            if (direction == RelIdArray.DirectionWrapper.BOTH) {
                return this.directions.get((Object)RelIdArray.DirectionWrapper.OUTGOING).hasMore(direction, types) || this.directions.get((Object)RelIdArray.DirectionWrapper.INCOMING).hasMore(direction, types) || this.directions.get((Object)RelIdArray.DirectionWrapper.BOTH).hasMore(direction, types);
            }
            return this.directions.get((Object)direction).hasMore(direction, types) || this.directions.get((Object)RelIdArray.DirectionWrapper.BOTH).hasMore(direction, types);
        }

        @Override
        public void compareAndAdvance(RelIdArray.DirectionWrapper direction, int type, long relIdDeleted, long nextRelId) {
            this.directions.get((Object)direction).compareAndAdvance(direction, type, relIdDeleted, nextRelId);
        }

        @Override
        public RelationshipLoadingPosition clone() {
            return new TypePosition(this);
        }

        public String toString() {
            return this.directions.toString();
        }
    }
}

