/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.function.Function2;
import org.neo4j.kernel.impl.store.counts.CountsTrackerState;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.IndexCountsKey;
import org.neo4j.kernel.impl.store.counts.keys.IndexSampleKey;
import org.neo4j.kernel.impl.store.counts.keys.NodeKey;
import org.neo4j.kernel.impl.store.counts.keys.RelationshipKey;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordVisitor;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStore;
import org.neo4j.register.ConcurrentRegisters;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

class ConcurrentCountsTrackerState
implements CountsTrackerState {
    private static final int INITIAL_CHANGES_CAPACITY = 1024;
    private final SortedKeyValueStore<CountsKey, Register.CopyableDoubleLongRegister> store;
    private final ConcurrentMap<CountsKey, Register.CopyableDoubleLongRegister> changes = new ConcurrentHashMap<CountsKey, Register.CopyableDoubleLongRegister>(1024);
    private static final Function2<Long, Long, Boolean> NON_NEGATIVE = new Function2<Long, Long, Boolean>(){

        public Boolean apply(Long first, Long second) {
            return first >= 0L && second >= 0L;
        }
    };

    ConcurrentCountsTrackerState(SortedKeyValueStore<CountsKey, Register.CopyableDoubleLongRegister> store) {
        this.store = store;
    }

    public String toString() {
        return String.format("ConcurrentTrackerState[store=%s - %s]", this.store, this.changes.toString());
    }

    @Override
    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    @Override
    public Register.DoubleLongRegister nodeCount(NodeKey nodeKey, Register.DoubleLongRegister target) {
        return this.readIntoRegister(nodeKey, target);
    }

    @Override
    public void incrementNodeCount(NodeKey key, long delta) {
        if (delta == 0L) {
            return;
        }
        Register.CopyableDoubleLongRegister register = this.writeRegister(key);
        register.increment(0L, delta);
        assert (register.satisfies(NON_NEGATIVE)) : String.format("incrementNodeCount(key=%s, delta=%d) -> %s", key, delta, register);
    }

    @Override
    public Register.DoubleLongRegister relationshipCount(RelationshipKey key, Register.DoubleLongRegister target) {
        return this.readIntoRegister(key, target);
    }

    @Override
    public void incrementRelationshipCount(RelationshipKey key, long delta) {
        if (delta == 0L) {
            return;
        }
        Register.CopyableDoubleLongRegister register = this.writeRegister(key);
        register.increment(0L, delta);
        assert (register.satisfies(NON_NEGATIVE)) : String.format("incrementRelationshipCount(key=%s, delta=%d) -> %s", key, delta, register);
    }

    @Override
    public void replaceIndexUpdatesAndSize(IndexCountsKey key, long updates, long size) {
        assert (updates >= 0L && size >= 0L) : String.format("replaceIndexSize(key=%s, updates=%d, size=%d)", key, updates, size);
        this.writeRegister(key).write(updates, size);
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(IndexCountsKey key, Register.DoubleLongRegister target) {
        return this.readIntoRegister(key, target);
    }

    @Override
    public void incrementIndexUpdates(IndexCountsKey key, long delta) {
        if (delta == 0L) {
            return;
        }
        assert (delta > 0L) : String.format("incrementIndexUpdates(key=%s, delta=%d)", key, delta);
        this.writeRegister(key).increment(delta, 0L);
    }

    @Override
    public Register.DoubleLongRegister indexSample(IndexSampleKey key, Register.DoubleLongRegister target) {
        return this.readIntoRegister(key, target);
    }

    @Override
    public void replaceIndexSample(IndexSampleKey key, long unique, long size) {
        assert (unique >= 0L && size >= 0L && unique <= size) : String.format("replaceIndexSample(key=%s, unique=%d, size=%d)", key, unique, size);
        this.writeRegister(key).write(unique, size);
    }

    private Register.DoubleLongRegister readIntoRegister(CountsKey key, Register.DoubleLongRegister target) {
        Register.CopyableDoubleLongRegister sample = (Register.CopyableDoubleLongRegister)this.changes.get(key);
        if (sample == null) {
            this.store.get(key, (Register.CopyableDoubleLongRegister)target);
        } else {
            sample.copyTo((Register.DoubleLong.Out)target);
        }
        return target;
    }

    private Register.CopyableDoubleLongRegister writeRegister(CountsKey key) {
        Register.CopyableDoubleLongRegister sample = (Register.CopyableDoubleLongRegister)this.changes.get(key);
        if (sample == null) {
            sample = ConcurrentRegisters.OptimisticRead.newDoubleLongRegister();
            this.store.get(key, sample);
            Register.CopyableDoubleLongRegister previous = this.changes.putIfAbsent(key, sample);
            return previous == null ? sample : previous;
        }
        return sample;
    }

    @Override
    public File storeFile() {
        return this.store.file();
    }

    @Override
    public long lastTxId() {
        return this.store.lastTxId();
    }

    @Override
    public SortedKeyValueStore.Writer<CountsKey, Register.CopyableDoubleLongRegister> newWriter(File file, long lastCommittedTxId) throws IOException {
        return this.store.newWriter(file, lastCommittedTxId);
    }

    @Override
    public void accept(KeyValueRecordVisitor<CountsKey, Register.CopyableDoubleLongRegister> visitor) {
        try (Merger<CountsKey> merger = new Merger<CountsKey>(visitor, ConcurrentCountsTrackerState.sortedUpdates(this.changes));){
            this.store.accept(merger, (Register.CopyableDoubleLongRegister)Registers.newDoubleLongRegister());
        }
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    private static Update<CountsKey>[] sortedUpdates(ConcurrentMap<CountsKey, Register.CopyableDoubleLongRegister> updates) {
        Object[] result = new Update[updates.size()];
        Register.DoubleLongRegister tmp = Registers.newDoubleLongRegister();
        Iterator entries = updates.entrySet().iterator();
        for (int i = 0; i < result.length; ++i) {
            if (!entries.hasNext()) {
                throw new ConcurrentModificationException("fewer entries than expected");
            }
            result[i] = Update.from(entries.next(), tmp);
        }
        if (entries.hasNext()) {
            throw new ConcurrentModificationException("more entries than expected");
        }
        Arrays.sort(result);
        return result;
    }

    private static final class Update<K extends Comparable<K>>
    implements Comparable<Update<K>> {
        final K key;
        final long first;
        final long second;

        static <K extends Comparable<K>> Update<K> from(Map.Entry<K, Register.CopyableDoubleLongRegister> entry, Register.DoubleLongRegister register) {
            entry.getValue().copyTo((Register.DoubleLong.Out)register);
            return new Update<Comparable>((Comparable)entry.getKey(), register.readFirst(), register.readSecond());
        }

        Update(K key, long first, long second) {
            this.key = key;
            this.first = first;
            this.second = second;
        }

        void writeTo(Register.DoubleLong.Out target) {
            target.write(this.first, this.second);
        }

        public String toString() {
            return String.format("Update{key=%s, first=%d, second=%d}", this.key, this.first, this.second);
        }

        @Override
        public int compareTo(Update<K> that) {
            return this.key.compareTo(that.key);
        }
    }

    private static final class Merger<K extends Comparable<K>>
    implements KeyValueRecordVisitor<K, Register.CopyableDoubleLongRegister>,
    AutoCloseable {
        private final KeyValueRecordVisitor<K, Register.CopyableDoubleLongRegister> target;
        private final Register.CopyableDoubleLongRegister tmp = Registers.newDoubleLongRegister();
        private final Update<K>[] updates;
        private int next;

        public Merger(KeyValueRecordVisitor<K, Register.CopyableDoubleLongRegister> target, Update<K>[] updates) {
            this.target = target;
            this.updates = updates;
        }

        @Override
        public void visit(K key, Register.CopyableDoubleLongRegister register) {
            while (this.next < this.updates.length) {
                Update<K> nextUpdate = this.updates[this.next];
                int cmp = key.compareTo(nextUpdate.key);
                if (cmp == 0) {
                    ++this.next;
                    nextUpdate.writeTo((Register.DoubleLong.Out)register);
                    break;
                }
                if (cmp <= 0) break;
                ++this.next;
                register.copyTo((Register.DoubleLong.Out)this.tmp);
                nextUpdate.writeTo((Register.DoubleLong.Out)register);
                this.target.visit(nextUpdate.key, register);
                this.tmp.copyTo((Register.DoubleLong.Out)register);
            }
            this.target.visit(key, register);
        }

        @Override
        public void close() {
            if (this.next < this.updates.length) {
                for (int i = this.next; i < this.updates.length; ++i) {
                    Update<K> update = this.updates[i];
                    update.writeTo((Register.DoubleLong.Out)this.tmp);
                    this.target.visit(update.key, this.tmp);
                }
            }
        }
    }
}

