/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreUtil;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogs;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.PropertyDeduplicator;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.WriterFactories;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerators;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStore;

public class StoreMigrator
implements StoreMigrationParticipant {
    private static final Object[] NO_PROPERTIES = new Object[0];
    private final MigrationProgressMonitor progressMonitor;
    private final FileSystemAbstraction fileSystem;
    private final UpgradableDatabase upgradableDatabase;
    private final Config config;
    private final Logging logging;
    private final LegacyLogs legacyLogs;
    private String versionToUpgradeFrom;

    public StoreMigrator(MigrationProgressMonitor progressMonitor, FileSystemAbstraction fileSystem, Logging logging) {
        this(progressMonitor, fileSystem, new UpgradableDatabase(new StoreVersionCheck(fileSystem)), new Config(), logging);
    }

    public StoreMigrator(MigrationProgressMonitor progressMonitor, FileSystemAbstraction fileSystem, UpgradableDatabase upgradableDatabase, Config config, Logging logging) {
        this.progressMonitor = progressMonitor;
        this.fileSystem = fileSystem;
        this.upgradableDatabase = upgradableDatabase;
        this.config = config;
        this.logging = logging;
        this.legacyLogs = new LegacyLogs(fileSystem);
    }

    @Override
    public boolean needsMigration(File storeDir) throws IOException {
        NeoStoreUtil neoStoreUtil = new NeoStoreUtil(storeDir, this.fileSystem);
        String versionAsString = NeoStore.versionLongToString(neoStoreUtil.getStoreVersion());
        boolean sameVersion = "v0.A.4".equals(versionAsString);
        if (!sameVersion) {
            this.upgradableDatabase.checkUpgradeable(storeDir);
        }
        return !sameVersion;
    }

    private String versionToUpgradeFrom(FileSystemAbstraction fileSystem, File storeDir) {
        if (this.versionToUpgradeFrom == null) {
            this.versionToUpgradeFrom = this.upgradableDatabase.checkUpgradeable(storeDir);
        }
        return this.versionToUpgradeFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(File storeDir, File migrationDir, SchemaIndexProvider schemaIndexProvider, PageCache pageCache) throws IOException {
        this.progressMonitor.started();
        NeoStoreUtil neoStoreAccess = new NeoStoreUtil(storeDir, this.fileSystem);
        long lastTxId = neoStoreAccess.getLastCommittedTx();
        long lastTxChecksum = this.extractTransactionChecksum(neoStoreAccess, storeDir, lastTxId);
        this.writeLastTxChecksum(migrationDir, lastTxChecksum);
        if (this.versionToUpgradeFrom(this.fileSystem, storeDir).equals("v0.A.3")) {
            LifeSupport life = new LifeSupport();
            life.start();
            try {
                this.removeDuplicateEntityProperties(storeDir, migrationDir, pageCache, schemaIndexProvider);
                this.rebuildCountsFromScratch(storeDir, migrationDir, lastTxId, pageCache);
            }
            finally {
                life.shutdown();
            }
        } else {
            this.migrateWithBatchImporter(storeDir, migrationDir, lastTxId, lastTxChecksum, pageCache);
        }
        this.progressMonitor.finished();
    }

    private void writeLastTxChecksum(File migrationDir, long lastTxChecksum) throws IOException {
        try (Writer writer = this.fileSystem.openAsWriter(this.lastTxChecksumFile(migrationDir), "utf-8", false);){
            writer.write(String.valueOf(lastTxChecksum));
        }
    }

    private long readLastTxChecksum(File migrationDir) throws IOException {
        try (Reader reader = this.fileSystem.openAsReader(this.lastTxChecksumFile(migrationDir), "utf-8");){
            char[] buffer = new char[100];
            int chars = reader.read(buffer);
            long l = Long.parseLong(String.valueOf(buffer, 0, chars));
            return l;
        }
    }

    private File lastTxChecksumFile(File migrationDir) {
        return new File(migrationDir, "lastxchecksum");
    }

    private long extractTransactionChecksum(NeoStoreUtil neoStoreAccess, File storeDir, long txId) {
        try {
            return neoStoreAccess.getLastCommittedTxChecksum();
        }
        catch (IllegalStateException e) {
            try {
                return this.legacyLogs.getTransactionChecksum(storeDir, txId);
            }
            catch (IOException ioe) {
                return txId == 1L ? 0L : Math.abs(new Random().nextLong());
            }
        }
    }

    private void copyStores(File storeDir, File migrationDir, String ... suffixes) throws IOException {
        for (String suffix : suffixes) {
            FileUtils.copyFile((File)new File(storeDir, "neostore" + suffix), (File)new File(migrationDir, "neostore" + suffix));
        }
    }

    private void removeDuplicateEntityProperties(File storeDir, File migrationDir, PageCache pageCache, SchemaIndexProvider schemaIndexProvider) throws IOException {
        this.copyStores(storeDir, migrationDir, ".propertystore.db", ".propertystore.db.id", ".propertystore.db.index.keys", ".propertystore.db.index.keys.id", ".propertystore.db.index", ".propertystore.db.index.id", ".propertystore.db.strings", ".propertystore.db.arrays", ".nodestore.db", ".nodestore.db.id", ".nodestore.db.labels", ".schemastore.db");
        PropertyDeduplicator deduplicator = new PropertyDeduplicator(this.fileSystem, migrationDir, pageCache, schemaIndexProvider);
        deduplicator.deduplicateProperties();
    }

    private void rebuildCountsFromScratch(File storeDir, File migrationDir, long lastTxId, PageCache pageCache) throws IOException {
        File storeFileBase = new File(migrationDir, "neostore.counts.db");
        CountsTracker.createEmptyCountsStore(pageCache, storeFileBase, StoreFactory.buildTypeDescriptorAndVersion(CountsTracker.STORE_DESCRIPTOR));
        StoreFactory storeFactory = new StoreFactory(this.fileSystem, storeDir, pageCache, StringLogger.DEV_NULL, new Monitors(), StoreVersionMismatchHandler.ALLOW_OLD_VERSION);
        try (NodeStore nodeStore = storeFactory.newNodeStore();
             RelationshipStore relationshipStore = storeFactory.newRelationshipStore();
             CountsTracker tracker = new CountsTracker(this.logging.getMessagesLog(CountsTracker.class), this.fileSystem, pageCache, storeFileBase);){
            CountsComputer.computeCounts(nodeStore, relationshipStore).accept(new CountsAccessor.Initializer(tracker));
            tracker.rotate(lastTxId);
        }
    }

    private void migrateWithBatchImporter(File storeDir, File migrationDir, long lastTxId, long lastTxChecksum, PageCache pageCache) throws IOException {
        LegacyStore legacyStore;
        this.prepareBatchImportMigration(storeDir, migrationDir);
        switch (this.versionToUpgradeFrom) {
            case "v0.A.0": {
                legacyStore = new Legacy19Store(this.fileSystem, new File(storeDir, "neostore"));
                break;
            }
            case "v0.A.1": {
                legacyStore = new Legacy20Store(this.fileSystem, new File(storeDir, "neostore"));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown version to upgrade from: " + this.versionToUpgradeFrom);
            }
        }
        ParallelBatchImporter importer = new ParallelBatchImporter(migrationDir.getAbsolutePath(), this.fileSystem, new Configuration.OverrideFromConfig(this.config), this.logging, this.migrationBatchImporterMonitor(legacyStore, this.progressMonitor), WriterFactories.parallel(), this.readAdditionalIds(storeDir, lastTxId, lastTxChecksum));
        Iterable<InputNode> nodes = this.legacyNodesAsInput(legacyStore);
        Iterable<InputRelationship> relationships = this.legacyRelationshipsAsInput(legacyStore);
        importer.doImport(Inputs.input(nodes, relationships, IdMappers.actual(), IdGenerators.fromInput()));
        StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDir, null, Iterables.iterable(StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_STRING_STORE, StoreFile.PROPERTY_ARRAY_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE), true, false, StoreFileType.values());
        if (legacyStore instanceof Legacy19Store) {
            this.migratePropertyKeys((Legacy19Store)legacyStore, pageCache, migrationDir);
        }
        legacyStore.close();
    }

    private void prepareBatchImportMigration(File storeDir, File migrationDir) throws IOException {
        BatchingNeoStore.createStore(this.fileSystem, migrationDir.getPath());
        Iterable<StoreFile> storeFiles = Iterables.iterable(StoreFile.NODE_LABEL_STORE);
        StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, storeFiles, true, false, StoreFileType.values());
        StoreFile.ensureStoreVersion(this.fileSystem, migrationDir, storeFiles);
    }

    private AdditionalInitialIds readAdditionalIds(File storeDir, final long lastTxId, final long lastTxChecksum) throws IOException {
        final int propertyKeyTokenHighId = this.readHighIdFromIdFileIfExists(storeDir, ".propertystore.db.index");
        final int labelTokenHighId = this.readHighIdFromIdFileIfExists(storeDir, ".labeltokenstore.db");
        final int relationshipTypeTokenHighId = this.readHighIdFromIdFileIfExists(storeDir, ".relationshiptypestore.db");
        return new AdditionalInitialIds(){

            @Override
            public int highRelationshipTypeTokenId() {
                return relationshipTypeTokenHighId;
            }

            @Override
            public int highPropertyKeyTokenId() {
                return propertyKeyTokenHighId;
            }

            @Override
            public int highLabelTokenId() {
                return labelTokenHighId;
            }

            @Override
            public long lastCommittedTransactionId() {
                return lastTxId;
            }

            @Override
            public long lastCommittedTransactionChecksum() {
                return lastTxChecksum;
            }
        };
    }

    private int readHighIdFromIdFileIfExists(File storeDir, String storeName) throws IOException {
        String file = StoreFileType.ID.augment(new File(storeDir, "neostore" + storeName).getPath());
        try {
            return (int)IdGeneratorImpl.readHighId(this.fileSystem, new File(file));
        }
        catch (FileNotFoundException e) {
            return 0;
        }
    }

    private ExecutionMonitor migrationBatchImporterMonitor(LegacyStore legacyStore, MigrationProgressMonitor progressMonitor2) {
        return new CoarseBoundedProgressExecutionMonitor(legacyStore.getNodeStoreReader().getMaxId(), legacyStore.getRelStoreReader().getMaxId()){

            @Override
            protected void percent(int percent) {
                StoreMigrator.this.progressMonitor.percentComplete(percent);
            }
        };
    }

    private StoreFactory storeFactory(PageCache pageCache, File migrationDir) {
        return new StoreFactory(StoreFactory.configForStoreDir(this.config, migrationDir), new DefaultIdGeneratorFactory(), pageCache, this.fileSystem, StringLogger.DEV_NULL, new Monitors());
    }

    private void migratePropertyKeys(Legacy19Store legacyStore, PageCache pageCache, File migrationDir) throws IOException {
        Token[] tokens = legacyStore.getPropertyIndexReader().readTokens();
        if (this.containsAnyDuplicates(tokens)) {
            StoreFactory storeFactory = this.storeFactory(pageCache, migrationDir);
            storeFactory.createPropertyStore();
            try (PropertyStore propertyStore = storeFactory.newPropertyStore();){
                Map<Integer, Integer> propertyKeyTranslation = this.dedupAndWritePropertyKeyTokenStore(propertyStore, tokens);
                this.migratePropertyStore(legacyStore, propertyKeyTranslation, propertyStore);
            }
        }
    }

    private boolean containsAnyDuplicates(Token[] tokens) {
        HashSet<String> names = new HashSet<String>();
        for (Token token : tokens) {
            if (names.add(token.name())) continue;
            return true;
        }
        return false;
    }

    private Map<Integer, Integer> dedupAndWritePropertyKeyTokenStore(PropertyStore propertyStore, Token[] tokens) {
        PropertyKeyTokenStore keyTokenStore = propertyStore.getPropertyKeyTokenStore();
        HashMap<Integer, Integer> translations = new HashMap<Integer, Integer>();
        HashMap<String, Integer> createdTokens = new HashMap<String, Integer>();
        for (Token token : tokens) {
            Integer id = (Integer)createdTokens.get(token.name());
            if (id == null) {
                id = (int)keyTokenStore.nextId();
                PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
                Collection<DynamicRecord> nameRecords = keyTokenStore.allocateNameRecords(UTF8.encode(token.name()));
                record.setNameId((int)IteratorUtil.first(nameRecords).getId());
                record.addNameRecords(nameRecords);
                record.setInUse(true);
                record.setCreated();
                keyTokenStore.updateRecord(record);
                createdTokens.put(token.name(), id);
            }
            translations.put(token.id(), id);
        }
        return translations;
    }

    private void migratePropertyStore(Legacy19Store legacyStore, Map<Integer, Integer> propertyKeyTranslation, PropertyStore propertyStore) throws IOException {
        long lastInUseId = -1L;
        for (PropertyRecord propertyRecord : IteratorUtil.loop(legacyStore.getPropertyStoreReader().readPropertyStore())) {
            for (PropertyBlock block : propertyRecord.getPropertyBlocks()) {
                int key = block.getKeyIndexId();
                Integer translation = propertyKeyTranslation.get(key);
                if (translation == null) continue;
                block.setKeyIndexId(translation);
            }
            propertyStore.setHighId(propertyRecord.getId() + 1L);
            propertyStore.updateRecord(propertyRecord);
            for (long id = lastInUseId + 1L; id < propertyRecord.getId(); ++id) {
                propertyStore.freeId(id);
            }
            lastInUseId = propertyRecord.getId();
        }
    }

    private StoreFile[] allExcept(StoreFile ... exceptions) {
        ArrayList<StoreFile> result = new ArrayList<StoreFile>();
        result.addAll(Arrays.asList(StoreFile.values()));
        for (StoreFile except : exceptions) {
            result.remove((Object)except);
        }
        return result.toArray(new StoreFile[result.size()]);
    }

    private Iterable<InputRelationship> legacyRelationshipsAsInput(LegacyStore legacyStore) {
        final LegacyRelationshipStoreReader reader = legacyStore.getRelStoreReader();
        return new Iterable<InputRelationship>(){

            @Override
            public Iterator<InputRelationship> iterator() {
                Iterator<RelationshipRecord> source;
                try {
                    source = reader.iterator(0L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new IteratorWrapper<InputRelationship, RelationshipRecord>(source){

                    @Override
                    protected InputRelationship underlyingObjectToObject(RelationshipRecord record) {
                        return new InputRelationship(record.getId(), NO_PROPERTIES, record.getNextProp(), record.getFirstNode(), record.getSecondNode(), null, record.getType());
                    }
                };
            }
        };
    }

    private Iterable<InputNode> legacyNodesAsInput(LegacyStore legacyStore) {
        final LegacyNodeStoreReader reader = legacyStore.getNodeStoreReader();
        final String[] NO_LABELS = new String[]{};
        return new Iterable<InputNode>(){

            @Override
            public Iterator<InputNode> iterator() {
                Iterator<NodeRecord> source;
                try {
                    source = reader.iterator();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new IteratorWrapper<InputNode, NodeRecord>(source){

                    @Override
                    protected InputNode underlyingObjectToObject(NodeRecord record) {
                        return new InputNode(record.getId(), NO_PROPERTIES, record.getNextProp(), NO_LABELS, record.getLabelField());
                    }
                };
            }
        };
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir) throws IOException {
        StoreFile[] idFilesToDelete;
        List<StoreFile> filesToMove;
        switch (this.versionToUpgradeFrom(this.fileSystem, storeDir)) {
            case "v0.A.0": {
                filesToMove = Arrays.asList(StoreFile.NODE_STORE, StoreFile.RELATIONSHIP_STORE, StoreFile.RELATIONSHIP_GROUP_STORE, StoreFile.LABEL_TOKEN_STORE, StoreFile.NODE_LABEL_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE, StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.SCHEMA_STORE, StoreFile.COUNTS_STORE_ALPHA, StoreFile.COUNTS_STORE_BETA);
                idFilesToDelete = this.allExcept(StoreFile.RELATIONSHIP_GROUP_STORE);
                break;
            }
            case "v0.A.1": {
                filesToMove = Arrays.asList(StoreFile.NODE_STORE, StoreFile.RELATIONSHIP_STORE, StoreFile.RELATIONSHIP_GROUP_STORE, StoreFile.COUNTS_STORE_ALPHA, StoreFile.COUNTS_STORE_BETA);
                idFilesToDelete = this.allExcept(StoreFile.RELATIONSHIP_GROUP_STORE);
                break;
            }
            case "v0.A.3": {
                filesToMove = Arrays.asList(StoreFile.NODE_STORE, StoreFile.COUNTS_STORE_ALPHA, StoreFile.COUNTS_STORE_BETA, StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE);
                idFilesToDelete = new StoreFile[]{};
                break;
            }
            default: {
                throw new IllegalStateException("Unknown version to upgrade from: " + this.versionToUpgradeFrom);
            }
        }
        StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDir, null, Iterables.iterable(idFilesToDelete), true, false, StoreFileType.ID);
        StoreFile.fileOperation(FileOperation.MOVE, this.fileSystem, migrationDir, storeDir, filesToMove, true, true, StoreFileType.values());
        this.ensureStoreVersions(storeDir);
        this.updateOrAddNeoStoreFieldsAsPartOfMigration(migrationDir, storeDir);
        this.legacyLogs.operate(FileOperation.DELETE, storeDir, null);
        this.legacyLogs.deleteUnusedLogFiles(storeDir);
    }

    private void ensureStoreVersions(File dir) throws IOException {
        Iterable<StoreFile> versionedStores = Iterables.iterable(this.allExcept(StoreFile.COUNTS_STORE_ALPHA, StoreFile.COUNTS_STORE_BETA));
        StoreFile.ensureStoreVersion(this.fileSystem, dir, versionedStores);
    }

    private void updateOrAddNeoStoreFieldsAsPartOfMigration(File migrationDir, File storeDir) throws IOException {
        File storeDirNeoStore = new File(storeDir, "neostore");
        NeoStore.setRecord(this.fileSystem, storeDirNeoStore, NeoStore.Position.UPGRADE_TRANSACTION_ID, NeoStore.getRecord(this.fileSystem, storeDirNeoStore, NeoStore.Position.LAST_TRANSACTION_ID));
        NeoStore.setRecord(this.fileSystem, storeDirNeoStore, NeoStore.Position.UPGRADE_TIME, System.currentTimeMillis());
        long lastTxChecksum = this.readLastTxChecksum(migrationDir);
        NeoStore.setRecord(this.fileSystem, storeDirNeoStore, NeoStore.Position.LAST_TRANSACTION_CHECKSUM, lastTxChecksum);
        NeoStore.setRecord(this.fileSystem, storeDirNeoStore, NeoStore.Position.UPGRADE_TRANSACTION_CHECKSUM, lastTxChecksum);
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
        this.fileSystem.deleteRecursively(migrationDir);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }
}

