/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.IndexCommandDetector;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriterv1;
import org.neo4j.kernel.impl.util.IdOrderingQueue;

abstract class AbstractPhysicalTransactionAppender
implements TransactionAppender {
    protected final WritableLogChannel channel;
    private final TransactionMetadataCache transactionMetadataCache;
    protected final LogFile logFile;
    private final LogRotation logRotation;
    private final TransactionIdStore transactionIdStore;
    private final TransactionLogWriter transactionLogWriter;
    private final LogPositionMarker positionMarker = new LogPositionMarker();
    private final IndexCommandDetector indexCommandDetector;
    protected final IdOrderingQueue legacyIndexTransactionOrdering;

    protected AbstractPhysicalTransactionAppender(LogFile logFile, LogRotation logRotation, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, IdOrderingQueue legacyIndexTransactionOrdering) {
        this.logFile = logFile;
        this.logRotation = logRotation;
        this.transactionIdStore = transactionIdStore;
        this.legacyIndexTransactionOrdering = legacyIndexTransactionOrdering;
        this.channel = logFile.getWriter();
        this.transactionMetadataCache = transactionMetadataCache;
        this.indexCommandDetector = new IndexCommandDetector(new CommandWriter(this.channel));
        this.transactionLogWriter = new TransactionLogWriter(new LogEntryWriterv1(this.channel, this.indexCommandDetector));
    }

    private boolean append0(TransactionRepresentation transaction, long transactionId) throws IOException {
        LogPosition logPosition = this.channel.getCurrentPosition(this.positionMarker).newPosition();
        this.indexCommandDetector.reset();
        this.transactionLogWriter.append(transaction, transactionId);
        long transactionChecksum = LogEntryStart.checksum(transaction.additionalHeader(), transaction.getMasterId(), transaction.getAuthorId());
        this.transactionMetadataCache.cacheTransactionMetadata(transactionId, logPosition, transaction.getMasterId(), transaction.getAuthorId(), transactionChecksum);
        this.emptyBufferIntoChannel();
        if (this.indexCommandDetector.hasWrittenAnyLegacyIndexCommand()) {
            this.legacyIndexTransactionOrdering.offer(transactionId);
        }
        boolean containsLegacyIndexCommands = this.indexCommandDetector.hasWrittenAnyLegacyIndexCommand();
        this.transactionIdStore.transactionCommitted(transactionId, transactionChecksum);
        return containsLegacyIndexCommands;
    }

    protected abstract void emptyBufferIntoChannel() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long append(TransactionRepresentation transaction) throws IOException {
        long transactionId = -1L;
        int phase = 0;
        this.logRotation.rotateLogIfNeeded();
        try {
            long ticket;
            boolean hasLegacyIndexChanges;
            LogFile logFile = this.logFile;
            synchronized (logFile) {
                transactionId = this.transactionIdStore.nextCommittingTransactionId();
                hasLegacyIndexChanges = this.append0(transaction, transactionId);
                phase = 1;
                ticket = this.getNextTicket();
            }
            this.forceAfterAppend(ticket);
            this.coordinateMultipleThreadsApplyingLegacyIndexChanges(hasLegacyIndexChanges, transactionId);
            phase = 2;
            long l = transactionId;
            return l;
        }
        finally {
            if (phase == 1) {
                this.transactionIdStore.transactionClosed(transactionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(TransactionRepresentation transaction, long expectedTransactionId) throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            long transactionId = this.transactionIdStore.nextCommittingTransactionId();
            if (transactionId != expectedTransactionId) {
                throw new ThisShouldNotHappenError("Zhen Li and Mattias Persson", "Received " + transaction + " with txId:" + expectedTransactionId + " to be applied, but appending it ended up generating an unexpected txId:" + transactionId);
            }
            this.append0(transaction, transactionId);
        }
    }

    @Override
    public void force() throws IOException {
        this.forceChannel();
    }

    protected abstract long getNextTicket();

    protected abstract void forceAfterAppend(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void forceChannel() throws IOException {
        WritableLogChannel writableLogChannel = this.channel;
        synchronized (writableLogChannel) {
            this.channel.force();
        }
    }

    private void coordinateMultipleThreadsApplyingLegacyIndexChanges(boolean hasLegacyIndexChanges, long transactionId) throws IOException {
        if (hasLegacyIndexChanges) {
            try {
                this.legacyIndexTransactionOrdering.waitFor(transactionId);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while waiting for applying legacy index updates", e);
            }
        }
    }

    @Override
    public void close() {
    }
}

