/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;

public class LogFileRecoverer
implements Visitor<LogVersionedStoreChannel, IOException> {
    private final LogEntryReader<ReadableVersionableLogChannel> logEntryReader;
    private final Visitor<CommittedTransactionRepresentation, IOException> visitor;

    public LogFileRecoverer(LogEntryReader<ReadableVersionableLogChannel> logEntryReader, Visitor<CommittedTransactionRepresentation, IOException> visitor) {
        this.logEntryReader = logEntryReader;
        this.visitor = visitor;
    }

    @Override
    public boolean visit(LogVersionedStoreChannel channel) throws IOException {
        ReadAheadLogChannel recoveredDataChannel = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS, 4096);
        try (PhysicalTransactionCursor<ReadableVersionableLogChannel> physicalTransactionCursor = new PhysicalTransactionCursor<ReadableVersionableLogChannel>(recoveredDataChannel, this.logEntryReader);){
            long lastKnownGoodPosition = channel.position();
            while (physicalTransactionCursor.next() && !this.visitor.visit(physicalTransactionCursor.get())) {
                lastKnownGoodPosition = channel.position();
            }
            if (channel.position() > lastKnownGoodPosition) {
                channel.truncate(lastKnownGoodPosition);
            }
        }
        if (this.visitor instanceof Closeable) {
            ((Closeable)((Object)this.visitor)).close();
        }
        return true;
    }
}

