/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.Recovery;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.state.RecoveryVisitor;
import org.neo4j.kernel.impl.util.StringLogger;

public class LoggingLogFileMonitor
implements PhysicalLogFile.Monitor,
RecoveryVisitor.Monitor,
LogRotation.Monitor,
Recovery.Monitor {
    private int numberOfRecoveredTransactions;
    private long firstTransactionRecovered;
    private long lastTransactionRecovered;
    private final StringLogger logger;

    public LoggingLogFileMonitor(StringLogger logger) {
        this.logger = logger;
    }

    @Override
    public void recoveryRequired(long recoveredLogVersion) {
        this.logger.info("Recovery required for log with version " + recoveredLogVersion);
    }

    @Override
    public void logRecovered() {
    }

    @Override
    public void recoveryCompleted() {
        if (this.numberOfRecoveredTransactions != 0) {
            this.logger.info(String.format("Recovery completed. %d transactions, first:%d, last:%d recovered", this.numberOfRecoveredTransactions, this.firstTransactionRecovered, this.lastTransactionRecovered));
        } else {
            this.logger.info("No recovery required");
        }
    }

    @Override
    public void rotatedLog() {
    }

    @Override
    public void transactionRecovered(long txId) {
        if (this.numberOfRecoveredTransactions == 0) {
            this.firstTransactionRecovered = txId;
        }
        this.lastTransactionRecovered = txId;
        ++this.numberOfRecoveredTransactions;
    }

    @Override
    public void opened(File logFile, long logVersion, long lastTransactionId, boolean clean) {
        this.logger.info(String.format("Opened logical log [%s] version=%d, lastTxId=%d (%s)", logFile, logVersion, lastTransactionId, clean ? "clean" : "recovered"));
    }

    @Override
    public void failureToTruncate(File logFile, IOException e) {
        this.logger.warn(String.format("Failed to truncate %s at correct size", logFile), e);
    }
}

