/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserDispatcher;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserFactory;

class VersionAwareLogEntryReader {
    private final LogEntryParserFactory logEntryParserFactory;
    private final CommandReaderFactory commandReaderFactory;
    private final LogPositionMarker positionMarker = new LogPositionMarker();

    VersionAwareLogEntryReader(LogEntryParserFactory logEntryParserFactory, CommandReaderFactory commandReaderFactory) {
        this.logEntryParserFactory = logEntryParserFactory;
        this.commandReaderFactory = commandReaderFactory;
    }

    LogEntry readLogEntry(ReadableLogChannel channel, byte logFormatVersion) throws IOException {
        try {
            Object entry;
            Object reader;
            channel.getCurrentPosition(this.positionMarker);
            LogEntryParserDispatcher dispatcher = this.logEntryParserFactory.newInstance(logFormatVersion);
            do {
                byte type = channel.get();
                byte version = 0;
                if (type < 0) {
                    version = type;
                    type = channel.get();
                }
                if ((reader = dispatcher.dispatch(type)) == null) {
                    LogPosition position = this.positionMarker.newPosition();
                    throw new IOException("Log format version: " + logFormatVersion + " - Unknown entry[" + type + "] at " + "position " + position + " and entry version " + version);
                }
                entry = reader.parse(version, channel, this.positionMarker, this.commandReaderFactory);
            } while (reader.skip());
            return entry;
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }
}

