/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.util.ArrayMap;

class BatchTokenHolder {
    private final ArrayMap<String, Integer> nameToId = new ArrayMap(5, false, false);
    private final ArrayMap<Integer, String> idToName = new ArrayMap(5, false, false);

    BatchTokenHolder(Token[] tokens) {
        for (Token token : tokens) {
            this.nameToId.put(token.name(), token.id());
            this.idToName.put(token.id(), token.name());
        }
    }

    void addToken(String stringKey, int keyId) {
        this.nameToId.put(stringKey, keyId);
        this.idToName.put(keyId, stringKey);
    }

    int idOf(String stringKey) {
        Integer id = this.nameToId.get(stringKey);
        if (id != null) {
            return id;
        }
        return -1;
    }

    String nameOf(int id) {
        String name = this.idToName.get(id);
        if (name == null) {
            throw new NotFoundException("No token with id:" + id);
        }
        return name;
    }
}

