/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.NodeStoreProcessorStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class NodeFirstRelationshipStep
extends NodeStoreProcessorStep
implements NodeRelationshipLink.GroupVisitor {
    private final RelationshipGroupStore relGroupStore;
    private final NodeRelationshipLink nodeRelationshipLink;
    private long nextGroupId = -1L;

    public NodeFirstRelationshipStep(StageControl control, Configuration config, NodeStore nodeStore, RelationshipGroupStore relGroupStore, NodeRelationshipLink nodeRelationshipLink) {
        super(control, "LINKER", config, nodeStore);
        this.relGroupStore = relGroupStore;
        this.nodeRelationshipLink = nodeRelationshipLink;
    }

    @Override
    protected boolean process(NodeRecord node) {
        long nodeId = node.getId();
        long firstRel = this.nodeRelationshipLink.getFirstRel(nodeId, this);
        if (firstRel == -1L) {
            return false;
        }
        node.setNextRel(firstRel);
        if (this.nodeRelationshipLink.isDense(nodeId)) {
            node.setDense(true);
        }
        return true;
    }

    @Override
    public long visit(long nodeId, int type, long next, long out, long in, long loop) {
        long id = this.nextGroupId != -1L ? this.nextGroupId : this.relGroupStore.nextId();
        this.nextGroupId = -1L;
        RelationshipGroupRecord groupRecord = new RelationshipGroupRecord(id, type);
        groupRecord.setInUse(true);
        groupRecord.setFirstOut(out);
        groupRecord.setFirstIn(in);
        groupRecord.setFirstLoop(loop);
        groupRecord.setOwningNode(nodeId);
        if (next != -1L) {
            this.nextGroupId = this.relGroupStore.nextId();
            groupRecord.setNext(this.nextGroupId);
        }
        this.relGroupStore.updateRecord(groupRecord);
        return id;
    }
}

