/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongBitsManipulator;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;

public class EncodingIdMapper
implements IdMapper {
    private static LongBitsManipulator COLLISION_BIT = new LongBitsManipulator(56, 1);
    public static int CACHE_CHUNK_SIZE = 1000000;
    private final IntArray trackerCache;
    private final LongArray dataCache;
    private final Encoder encoder;
    private final Radix radix;
    private final int processorsForSorting;
    private final LongArray collisionCache;
    private final IntArray collisionValuesIndex;
    private final List<Object> collisionValues = new ArrayList<Object>();
    private boolean readyForUse;
    private long[][] sortBuckets;
    private long size;

    public EncodingIdMapper(NumberArrayFactory cacheFactory, Encoder encoder, Radix radix) {
        this(cacheFactory, encoder, radix, CACHE_CHUNK_SIZE, Runtime.getRuntime().availableProcessors() - 1);
    }

    public EncodingIdMapper(NumberArrayFactory cacheFactory, Encoder encoder, Radix radix, int chunkSize, int processorsForSorting) {
        this.processorsForSorting = processorsForSorting;
        this.dataCache = EncodingIdMapper.newLongArray(cacheFactory, chunkSize);
        this.trackerCache = EncodingIdMapper.newIntArray(cacheFactory, chunkSize);
        this.encoder = encoder;
        this.radix = radix;
        this.collisionCache = EncodingIdMapper.newLongArray(cacheFactory, chunkSize);
        this.collisionValuesIndex = EncodingIdMapper.newIntArray(cacheFactory, chunkSize);
    }

    private static IntArray newIntArray(NumberArrayFactory cacheFactory, int chunkSize) {
        return cacheFactory.newDynamicIntArray(chunkSize, -1);
    }

    private static LongArray newLongArray(NumberArrayFactory cacheFactory, int chunkSize) {
        return cacheFactory.newDynamicLongArray(chunkSize, -1L);
    }

    @Override
    public long get(Object inputId) {
        assert (this.readyForUse);
        return this.binarySearch(inputId);
    }

    @Override
    public void put(Object inputId, long id) {
        long code = this.encoder.encode(inputId);
        this.dataCache.set(id, code);
        this.radix.registerRadixOf(code);
        ++this.size;
    }

    @Override
    public boolean needsPreparation() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(ResourceIterable<Object> ids) {
        EncodingIdMapper encodingIdMapper = this;
        synchronized (encodingIdMapper) {
            this.sortBuckets = new ParallelSort(this.radix, this.dataCache, this.trackerCache, this.processorsForSorting).run();
        }
        if (this.detectAndMarkCollisions() > 0) {
            try (ResourceIterator<Object> idIterator = ids.iterator();){
                this.buildCollisionInfo(idIterator);
            }
        }
        this.readyForUse = true;
    }

    private int radixOf(long value) {
        return this.radix.calculator().radixOf(value);
    }

    private long binarySearch(Object inputId) {
        long returnVal;
        long highestSetTrackerIndex;
        long low = 0L;
        long high = highestSetTrackerIndex = this.trackerCache.highestSetIndex();
        long x = this.encoder.encode(inputId);
        int rIndex = this.radixOf(x);
        for (int k = 0; k < this.sortBuckets.length; ++k) {
            if ((long)rIndex > this.sortBuckets[k][0]) continue;
            low = this.sortBuckets[k][1];
            high = k == this.sortBuckets.length - 1 ? this.trackerCache.size() - 1L : this.sortBuckets[k + 1][1];
            break;
        }
        if ((returnVal = this.binarySearch(x, inputId, false, low, high)) == -1L) {
            low = 0L;
            high = this.trackerCache.size() - 1L;
            returnVal = this.binarySearch(x, inputId, false, low, high);
        }
        return returnVal;
    }

    private static long setCollision(long value) {
        return COLLISION_BIT.set(value, 1, 1L);
    }

    static long clearCollision(long value) {
        return COLLISION_BIT.clear(value, 1, false);
    }

    private static boolean isCollision(long value) {
        return COLLISION_BIT.get(value, 1) != 0L;
    }

    private int detectAndMarkCollisions() {
        int numCollisions = 0;
        int i = 0;
        while ((long)i < this.trackerCache.size() - 1L) {
            if (EncodingIdMapper.compareDataCache(this.dataCache, this.trackerCache, i, i + 1, Utils.CompareType.GE)) {
                if (!EncodingIdMapper.compareDataCache(this.dataCache, this.trackerCache, i, i + 1, Utils.CompareType.EQ)) {
                    throw new IllegalStateException("Failure:[" + i + "] " + Long.toHexString(this.dataCache.get(this.trackerCache.get(i))) + ":" + Long.toHexString(this.dataCache.get(this.trackerCache.get(i + 1))) + " | " + this.radixOf(this.dataCache.get(this.trackerCache.get(i))) + ":" + this.radixOf(this.dataCache.get(this.trackerCache.get(i + 1))));
                }
                if (this.trackerCache.get(i) > this.trackerCache.get(i + 1)) {
                    this.trackerCache.swap(i, i + 1, 1);
                }
                long value = this.dataCache.get(this.trackerCache.get(i));
                value = EncodingIdMapper.setCollision(value);
                this.dataCache.set(this.trackerCache.get(i), value);
                value = this.dataCache.get(this.trackerCache.get(i + 1));
                value = EncodingIdMapper.setCollision(value);
                this.dataCache.set(this.trackerCache.get(i + 1), value);
                ++numCollisions;
            }
            ++i;
        }
        return numCollisions;
    }

    private void buildCollisionInfo(Iterator<Object> ids) {
        int collisionIndex = 0;
        HashSet<Object> collidedIds = new HashSet<Object>();
        long i = 0L;
        while (ids.hasNext()) {
            Object id = ids.next();
            long value = this.dataCache.get(i);
            if (EncodingIdMapper.isCollision(value)) {
                if (!collidedIds.add(id)) {
                    throw new IllegalStateException("Duplicate input ids. '" + id + "' existed in input more than once");
                }
                long val = this.encoder.encode(id);
                assert (val == EncodingIdMapper.clearCollision(value));
                int valueIndex = this.collisionValues.size();
                this.collisionValues.add(id);
                this.collisionCache.set(collisionIndex, i);
                this.collisionValuesIndex.set(collisionIndex, valueIndex);
                ++collisionIndex;
            }
            ++i;
        }
    }

    private long binarySearch(long x, Object inputId, boolean trackerIndex, long low, long high) {
        while (low <= high) {
            long mid = low + (high - low) / 2L;
            int index = this.trackerCache.get(mid);
            if (index == -1) {
                return -1L;
            }
            long midValue = this.dataCache.get(index);
            if (Utils.unsignedCompare(EncodingIdMapper.clearCollision(midValue), x, Utils.CompareType.EQ)) {
                if (trackerIndex) {
                    if (EncodingIdMapper.isCollision(midValue)) {
                        while (midValue == this.dataCache.get(this.trackerCache.get(mid - 1L))) {
                            --mid;
                        }
                    }
                    return mid;
                }
                if (EncodingIdMapper.isCollision(midValue)) {
                    return this.findFromCollisions(mid, inputId);
                }
                return index;
            }
            if (Utils.unsignedCompare(EncodingIdMapper.clearCollision(midValue), x, Utils.CompareType.LT)) {
                low = mid + 1L;
                continue;
            }
            high = mid - 1L;
        }
        return -1L;
    }

    private long findIndex(LongArray array, long value) {
        long low = 0L;
        long high = this.size - 1L;
        while (low <= high) {
            long mid = (low + high) / 2L;
            long midValue = array.get(mid);
            if (Utils.unsignedCompare(midValue, value, Utils.CompareType.EQ)) {
                return mid;
            }
            if (Utils.unsignedCompare(midValue, value, Utils.CompareType.LT)) {
                low = mid + 1L;
                continue;
            }
            high = mid - 1L;
        }
        return -1L;
    }

    private int findFromCollisions(long index, Object inputId) {
        if (this.collisionValues.isEmpty()) {
            return -1;
        }
        long val = EncodingIdMapper.clearCollision(this.dataCache.get(this.trackerCache.get(index)));
        assert (val == this.encoder.encode(inputId));
        while (index > 0L && Utils.unsignedCompare(val, EncodingIdMapper.clearCollision(this.dataCache.get(this.trackerCache.get(index - 1L))), Utils.CompareType.EQ)) {
            --index;
        }
        long fromIndex = index;
        while (index < this.trackerCache.highestSetIndex() && Utils.unsignedCompare(val, EncodingIdMapper.clearCollision(this.dataCache.get(this.trackerCache.get(index + 1L))), Utils.CompareType.EQ)) {
            ++index;
        }
        long toIndex = index;
        long[] collisionVals = new long[(int)(toIndex - fromIndex + 1L)];
        for (index = fromIndex; index <= toIndex; ++index) {
            collisionVals[(int)(index - fromIndex)] = this.findIndex(this.collisionCache, this.trackerCache.get(index));
        }
        for (int i = 0; i < collisionVals.length; ++i) {
            int collisionIndex = this.collisionValuesIndex.get(collisionVals[i]);
            Object value = this.collisionValues.get(collisionIndex);
            if (!inputId.equals(value)) continue;
            return this.trackerCache.get(fromIndex + (long)i);
        }
        return -1;
    }

    static boolean compareDataCache(LongArray dataCache, IntArray tracker, int a, int b, Utils.CompareType compareType) {
        int indexA = tracker.get(a);
        int indexB = tracker.get(b);
        if (indexA == -1 || indexB == -1) {
            return false;
        }
        return Utils.unsignedCompare(EncodingIdMapper.clearCollision(dataCache.get(indexA)), EncodingIdMapper.clearCollision(dataCache.get(indexB)), compareType);
    }

    @Override
    public void visitMemoryStats(MemoryStatsVisitor visitor) {
        this.dataCache.visitMemoryStats(visitor);
        this.trackerCache.visitMemoryStats(visitor);
        this.collisionCache.visitMemoryStats(visitor);
        this.collisionValuesIndex.visitMemoryStats(visitor);
    }
}

