/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class InputEntityDecorators {
    public static Function<InputNode, InputNode> additiveLabels(final String[] labelNamesToAdd) {
        if (labelNamesToAdd == null || labelNamesToAdd.length == 0) {
            return Functions.identity();
        }
        return new Function<InputNode, InputNode>(){

            public InputNode apply(InputNode node) {
                if (node.hasLabelField()) {
                    return node;
                }
                String[] union = ArrayUtil.union(node.labels(), labelNamesToAdd);
                if (union != node.labels()) {
                    node.setLabels(union);
                }
                return node;
            }
        };
    }

    public static Function<InputRelationship, InputRelationship> defaultRelationshipType(final String defaultType) {
        if (defaultType == null) {
            return Functions.identity();
        }
        return new Function<InputRelationship, InputRelationship>(){

            public InputRelationship apply(InputRelationship relationship) {
                if (relationship.type() == null && !relationship.hasTypeId()) {
                    relationship.setType(defaultType);
                }
                return relationship;
            }
        };
    }
}

