/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Mark;
import org.neo4j.function.Function;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.UnexpectedEndOfInputException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;

abstract class InputEntityDeserializer<ENTITY extends InputEntity>
extends PrefetchingResourceIterator<ENTITY> {
    private final Header header;
    private final CharSeeker data;
    private final Mark mark = new Mark();
    private final int[] delimiter;
    private final Function<ENTITY, ENTITY> decorator;
    private Object[] properties = new Object[20];
    private int propertiesCursor;

    InputEntityDeserializer(Header header, CharSeeker data, int[] delimiter, Function<ENTITY, ENTITY> decorator) {
        this.header = header;
        this.data = data;
        this.delimiter = delimiter;
        this.decorator = decorator;
    }

    @Override
    protected ENTITY fetchNextOrNull() {
        try {
            InputEntity inputEntity;
            Header.Entry[] entries = this.header.entries();
            for (int i = 0; i < entries.length; ++i) {
                if (!this.data.seek(this.mark, this.delimiter)) {
                    if (i > 0) {
                        throw new UnexpectedEndOfInputException("Near " + this.mark);
                    }
                    inputEntity = null;
                    return (ENTITY)inputEntity;
                }
                Header.Entry entry = entries[i];
                Object value = this.data.tryExtract(this.mark, entry.extractor()) ? entry.extractor().value() : null;
                boolean handled = true;
                switch (entry.type()) {
                    case PROPERTY: {
                        this.addProperty(entry, value);
                        break;
                    }
                    case IGNORE: {
                        break;
                    }
                    default: {
                        handled = false;
                    }
                }
                if (!handled) {
                    this.handleValue(entry, value);
                }
                if (this.mark.isEndOfLine()) break;
            }
            ENTITY entity = this.convertToInputEntity(this.properties());
            while (!this.mark.isEndOfLine()) {
                this.data.seek(this.mark, this.delimiter);
            }
            inputEntity = (InputEntity)this.decorator.apply(entity);
            return (ENTITY)inputEntity;
        }
        catch (IOException e) {
            throw new InputException("Unable to read more data from input stream", e);
        }
        finally {
            this.propertiesCursor = 0;
        }
    }

    protected void addProperty(Header.Entry entry, Object value) {
        if (value != null) {
            this.ensurePropertiesArrayCapacity(this.propertiesCursor + 2);
            this.properties[this.propertiesCursor++] = entry.name();
            this.properties[this.propertiesCursor++] = value;
        }
    }

    private Object[] properties() {
        return this.propertiesCursor > 0 ? Arrays.copyOf(this.properties, this.propertiesCursor) : InputEntity.NO_PROPERTIES;
    }

    private void ensurePropertiesArrayCapacity(int length) {
        if (length > this.properties.length) {
            this.properties = Arrays.copyOf(this.properties, length);
        }
    }

    @Override
    public void close() {
        try {
            this.data.close();
        }
        catch (IOException e) {
            throw new InputException("Unable to close data iterator", e);
        }
    }

    protected abstract ENTITY convertToInputEntity(Object[] var1);

    protected abstract void handleValue(Header.Entry var1, Object var2);
}

