/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.function.Function;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;

class InputRelationshipDeserializer
extends InputEntityDeserializer<InputRelationship> {
    private final IdSequence idSequence;
    private long id;
    private String type;
    private Object startNode;
    private Object endNode;

    InputRelationshipDeserializer(Header header, CharSeeker data, int[] delimiter, IdSequence idSequence, Function<InputRelationship, InputRelationship> decorator) {
        super(header, data, delimiter, decorator);
        this.idSequence = idSequence;
    }

    @Override
    protected void handleValue(Header.Entry entry, Object value) {
        switch (entry.type()) {
            case TYPE: {
                this.type = (String)value;
                break;
            }
            case START_ID: {
                this.startNode = value;
                break;
            }
            case END_ID: {
                this.endNode = value;
            }
        }
    }

    @Override
    protected InputRelationship convertToInputEntity(Object[] properties) {
        return new InputRelationship(this.idSequence.nextId(), properties, null, this.startNode, this.endNode, this.type, null);
    }
}

