/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.PropertyTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.core.EntityFactory;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class NodeManager
extends LifecycleAdapter
implements EntityFactory {
    private final ThreadToStatementContextBridge threadToTransactionBridge;
    private final NodeProxy.NodeActions nodeActions;
    private final RelationshipProxy.RelationshipActions relationshipActions;
    private final List<PropertyTracker<Node>> nodePropertyTrackers;
    private final List<PropertyTracker<Relationship>> relationshipPropertyTrackers;
    private long epoch;

    public NodeManager(NodeProxy.NodeActions nodeActions, RelationshipProxy.RelationshipActions relationshipActions, ThreadToStatementContextBridge threadToTransactionBridge) {
        this.nodeActions = nodeActions;
        this.relationshipActions = relationshipActions;
        this.threadToTransactionBridge = threadToTransactionBridge;
        this.nodePropertyTrackers = new CopyOnWriteArrayList<PropertyTracker<Node>>();
        this.relationshipPropertyTrackers = new CopyOnWriteArrayList<PropertyTracker<Relationship>>();
    }

    @Override
    public void init() {
    }

    @Override
    public void start() throws Throwable {
        this.epoch = System.currentTimeMillis();
    }

    @Override
    public NodeProxy newNodeProxyById(long id) {
        return new NodeProxy(this.nodeActions, id);
    }

    @Override
    public RelationshipProxy newRelationshipProxyById(long id) {
        return new RelationshipProxy(this.relationshipActions, id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RelationshipProxy newRelationshipProxy(long id) {
        try (Statement statement = this.threadToTransactionBridge.instance();){
            RelationshipProxy proxy = new RelationshipProxy(this.relationshipActions, id);
            statement.readOperations().relationshipVisit(id, proxy);
            RelationshipProxy relationshipProxy = proxy;
            return relationshipProxy;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    public RelationshipProxy newRelationshipProxy(long id, long startNodeId, int typeId, long endNodeId) {
        return new RelationshipProxy(this.relationshipActions, id, startNodeId, typeId, endNodeId);
    }

    @Override
    public GraphPropertiesImpl newGraphProperties() {
        return new GraphPropertiesImpl(this.epoch, this.threadToTransactionBridge);
    }

    public List<PropertyTracker<Node>> getNodePropertyTrackers() {
        return this.nodePropertyTrackers;
    }

    public List<PropertyTracker<Relationship>> getRelationshipPropertyTrackers() {
        return this.relationshipPropertyTrackers;
    }

    public void addNodePropertyTracker(PropertyTracker<Node> nodePropertyTracker) {
        this.nodePropertyTrackers.add(nodePropertyTracker);
    }

    public void removeNodePropertyTracker(PropertyTracker<Node> nodePropertyTracker) {
        this.nodePropertyTrackers.remove(nodePropertyTracker);
    }

    public void addRelationshipPropertyTracker(PropertyTracker<Relationship> relationshipPropertyTracker) {
        this.relationshipPropertyTrackers.add(relationshipPropertyTracker);
    }

    public void removeRelationshipPropertyTracker(PropertyTracker<Relationship> relationshipPropertyTracker) {
        this.relationshipPropertyTrackers.remove(relationshipPropertyTracker);
    }
}

