/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

public class LabelTokenStore
extends TokenStore<LabelTokenRecord> {
    public static final String TYPE_DESCRIPTOR = "LabelTokenStore";
    public static final int RECORD_SIZE = 5;

    public LabelTokenStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore nameStore, StoreVersionMismatchHandler versionMismatchHandler, Monitors monitors) {
        super(fileName, config, IdType.LABEL_TOKEN, idGeneratorFactory, pageCache, fileSystemAbstraction, stringLogger, nameStore, versionMismatchHandler, monitors);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, LabelTokenRecord record) throws FAILURE {
        processor.processLabelToken(this, record);
    }

    @Override
    protected LabelTokenRecord newRecord(int id) {
        return new LabelTokenRecord(id);
    }

    @Override
    protected void readRecord(LabelTokenRecord record, PageCursor cursor) {
        record.setNameId(cursor.getInt());
    }

    @Override
    protected void writeRecord(LabelTokenRecord record, PageCursor cursor) {
        cursor.putInt(record.getNameId());
    }

    @Override
    public int getRecordSize() {
        return 5;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

