/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;

public class NeoStoreUtil {
    private final Map<NeoStore.Position, Long> values = new HashMap<NeoStore.Position, Long>();

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Supply one argument which is the store directory of a neo4j graph database");
            System.exit(1);
        }
        System.out.println(new NeoStoreUtil(new File(args[0])));
    }

    public static boolean neoStoreExists(FileSystemAbstraction fs, File storeDir) {
        return fs.fileExists(NeoStoreUtil.neoStoreFile(storeDir, StoreFileType.STORE));
    }

    public NeoStoreUtil(File storeDir) {
        this(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    public NeoStoreUtil(File storeDir, FileSystemAbstraction fs) {
        File neoStoreFile = NeoStoreUtil.neoStoreFile(storeDir, StoreFileType.STORE);
        String currentTypeDescriptorAndVersion = NeoStore.buildTypeDescriptorAndVersion("NeoStore");
        boolean storeHasTrailer = this.hasTrailer(neoStoreFile, fs, currentTypeDescriptorAndVersion);
        try (StoreChannel channel = fs.open(neoStoreFile, "r");){
            int contentSize = (int)channel.size();
            if (storeHasTrailer) {
                int trailerSize = UTF8.encode(currentTypeDescriptorAndVersion).length;
                contentSize -= trailerSize;
            }
            int records = contentSize / 9;
            ByteBuffer buf = ByteBuffer.allocate(records * 9);
            channel.read(buf);
            buf.flip();
            for (int i = 0; buf.remaining() >= 9 && i < NeoStore.Position.values().length; ++i) {
                this.values.put(NeoStore.Position.values()[i], this.nextRecord(buf));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasTrailer(File neoStoreFile, FileSystemAbstraction fs, String currentTypeDescriptorAndVersion) {
        StoreVersionCheck trailerCheck = new StoreVersionCheck(fs);
        StoreVersionCheck.Result result = trailerCheck.hasVersion(neoStoreFile, currentTypeDescriptorAndVersion);
        return result.outcome == StoreVersionCheck.Result.Outcome.ok || result.outcome == StoreVersionCheck.Result.Outcome.unexpectedUpgradingStoreVersion;
    }

    private long nextRecord(ByteBuffer buf) {
        buf.get();
        return buf.getLong();
    }

    public long getValue(NeoStore.Position position) {
        Long value = this.values.get((Object)position);
        if (value == null) {
            throw new IllegalStateException("Wanted record " + (Object)((Object)position) + ", but this record wasn't read since the neostore didn't contain it");
        }
        return value;
    }

    public long getCreationTime() {
        return this.getValue(NeoStore.Position.TIME);
    }

    public long getStoreId() {
        return this.getValue(NeoStore.Position.RANDOM_NUMBER);
    }

    public long getLastCommittedTx() {
        return this.getValue(NeoStore.Position.LAST_TRANSACTION_ID);
    }

    public long getLogVersion() {
        return this.getValue(NeoStore.Position.LOG_VERSION);
    }

    public long getStoreVersion() {
        return this.getValue(NeoStore.Position.STORE_VERSION);
    }

    public long getFirstGraphProp() {
        return this.getValue(NeoStore.Position.FIRST_GRAPH_PROPERTY);
    }

    public long getLastCommittedTxChecksum() {
        return this.getValue(NeoStore.Position.LAST_TRANSACTION_CHECKSUM);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Neostore contents:%n");
        int i = 0;
        for (NeoStore.Position position : NeoStore.Position.values()) {
            Long value = this.values.get((Object)position);
            if (value == null) continue;
            builder.append(i++).append(": ").append(position.description()).append(": ").append(value).append("%n");
        }
        builder.append("=> store id: ").append(new StoreId(this.getCreationTime(), this.getStoreId(), this.getStoreVersion(), -1L, -1L));
        return String.format(builder.toString(), new Object[0]);
    }

    public static boolean storeExists(File storeDir) {
        return NeoStoreUtil.storeExists(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    public static boolean storeExists(File storeDir, FileSystemAbstraction fs) {
        return fs.fileExists(NeoStoreUtil.neoStoreFile(storeDir, StoreFileType.STORE));
    }

    private static File neoStoreFile(File storeDir, StoreFileType type) {
        return new File(storeDir, type.augment("neostore"));
    }
}

