/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.unsafe.impl.batchimport.RecordProcessor;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class RecordProcessorStep<T extends AbstractBaseRecord>
extends ProcessorStep<T[]> {
    private final RecordProcessor<T> processor;
    private final boolean endOfLine;

    public RecordProcessorStep(StageControl control, String name, org.neo4j.unsafe.impl.batchimport.Configuration config, RecordProcessor<T> processor, boolean endOfLine, StatsProvider ... additionalStatsProviders) {
        super(control, name, (Configuration)config, 1, additionalStatsProviders);
        this.processor = processor;
        this.endOfLine = endOfLine;
    }

    @Override
    protected void process(T[] batch, BatchSender sender) {
        for (T item : batch) {
            if (!((AbstractBaseRecord)item).inUse()) continue;
            this.processor.process(item);
        }
        if (!this.endOfLine) {
            sender.send(batch);
        }
    }

    @Override
    protected void done() {
        super.done();
        this.processor.done();
    }
}

